/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs;

import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IBaseGetInfoDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;

public class BaseGetInfoDialog
extends Dialog
implements IBaseGetInfoDialog {
    public static final String TARGET_NEW_CONNECTION_ICON_FILE = "icons/elcl16/enable_event.gif";
    protected CCombo fSessionsCombo = null;
    protected TraceSessionComponent[] fSessions;
    protected int fSessionIndex = 0;

    public BaseGetInfoDialog(Shell shell) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    @Override
    public TraceSessionComponent getSession() {
        return this.fSessions[this.fSessionIndex];
    }

    @Override
    public void setSessions(TraceSessionComponent[] sessions) {
        this.fSessions = Arrays.copyOf(sessions, sessions.length);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_EnableEventsDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(TARGET_NEW_CONNECTION_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        dialogComposite.setLayout((Layout)layout);
        dialogComposite.setLayoutData((Object)new GridData(1808));
        Group sessionsGroup = new Group(dialogComposite, 32);
        sessionsGroup.setText(Messages.TraceControl_EnableEventsSessionGroupName);
        layout = new GridLayout(1, true);
        sessionsGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        sessionsGroup.setLayoutData((Object)data);
        this.fSessionsCombo = new CCombo((Composite)sessionsGroup, 8);
        this.fSessionsCombo.setToolTipText(Messages.TraceControl_EnableEventsSessionsTooltip);
        this.fSessionsCombo.setLayoutData((Object)new GridData(768));
        String[] items = new String[this.fSessions.length];
        int i = 0;
        while (i < items.length) {
            items[i] = String.valueOf(this.fSessions[i].getName());
            ++i;
        }
        this.fSessionsCombo.setItems(items);
        this.fSessionsCombo.setEnabled(this.fSessions.length > 0);
        this.fSessionsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BaseGetInfoDialog.this.fSessionIndex = BaseGetInfoDialog.this.fSessionsCombo.getSelectionIndex();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getShell().setMinimumSize(new Point(300, 200));
        return dialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }
}

