/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.core.services;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.debug.gdbjtag.core.ILaunchConfigurationProvider;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.IPeripheralDMContext;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.PeripheralDMContext;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.PeripheralDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.services.IPeripheralsService;
import org.eclipse.embedcdt.internal.debug.gdbjtag.core.Activator;
import org.eclipse.embedcdt.packs.core.data.DurationMonitor;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.osgi.framework.BundleContext;

public class PeripheralsService
extends AbstractDsfService
implements IPeripheralsService {
    private ICommandControlService fCommandControl;
    private PeripheralDMContext[] fPeripheralsDMContexts = null;

    public PeripheralsService(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsService.initialize()");
        }
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                PeripheralsService.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsService.doInitialize()");
        }
        this.fCommandControl = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        this.register(new String[]{IPeripheralsService.class.getName(), PeripheralsService.class.getName()}, new Hashtable());
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsService registered " + this);
        }
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsService.shutdown()");
        }
        this.unregister();
        super.shutdown(rm);
    }

    protected BundleContext getBundleContext() {
        return Activator.getInstance().getBundle().getBundleContext();
    }

    @Override
    public void getPeripherals(IRunControl.IContainerDMContext containerDMContext, DataRequestMonitor<IPeripheralDMContext[]> drm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsService.getPeripherals()");
        }
        if (this.fPeripheralsDMContexts == null) {
            if (!(this.fCommandControl instanceof ILaunchConfigurationProvider)) {
                drm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", "No peripherals available."));
                drm.done();
                return;
            }
            ILaunchConfiguration launchConfiguration = ((ILaunchConfigurationProvider)this.fCommandControl).getLaunchConfiguration();
            try {
                IPath svdPath = SvdUtils.getSvdPath(launchConfiguration);
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("SVD path: " + svdPath);
                }
                DurationMonitor dm = new DurationMonitor();
                dm.start();
                Leaf tree = SvdUtils.getTree(svdPath);
                dm.stop();
                List<Leaf> list = SvdUtils.getPeripherals(tree);
                this.fPeripheralsDMContexts = this.createPeripheralsContexts((IDMContext)containerDMContext, list);
            }
            catch (CoreException e) {
                drm.setStatus(e.getStatus());
                drm.done();
                return;
            }
        }
        drm.setData((Object)this.fPeripheralsDMContexts);
        drm.done();
    }

    private PeripheralDMContext[] createPeripheralsContexts(IDMContext parentIDMContext, List<Leaf> list) {
        Object[] contexts = new PeripheralDMContext[list.size()];
        IDMContext[] parents = parentIDMContext != null ? new IDMContext[]{parentIDMContext} : new IDMContext[]{};
        int i = 0;
        for (Leaf child : list) {
            PeripheralDMNode node = new PeripheralDMNode(child);
            contexts[i] = new PeripheralDMContext(this.getSession(), parents, node);
            ++i;
        }
        Arrays.sort(contexts);
        return contexts;
    }
}

