/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.renderer.text;

import java.util.Set;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.text.LineBreakRendering;
import org.commonmark.renderer.text.TextContentNodeRendererContext;
import org.commonmark.renderer.text.TextContentWriter;

public class CoreTextContentNodeRenderer
extends AbstractVisitor
implements NodeRenderer {
    protected final TextContentNodeRendererContext context;
    private final TextContentWriter textContent;
    private ListHolder listHolder;

    public CoreTextContentNodeRenderer(TextContentNodeRendererContext context) {
        this.context = context;
        this.textContent = context.getWriter();
    }

    @Override
    public Set<Class<? extends Node>> getNodeTypes() {
        return Set.of(Document.class, Heading.class, Paragraph.class, BlockQuote.class, BulletList.class, FencedCodeBlock.class, HtmlBlock.class, ThematicBreak.class, IndentedCodeBlock.class, Link.class, ListItem.class, OrderedList.class, Image.class, Emphasis.class, StrongEmphasis.class, Text.class, Code.class, HtmlInline.class, SoftLineBreak.class, HardLineBreak.class);
    }

    @Override
    public void render(Node node) {
        node.accept(this);
    }

    @Override
    public void visit(Document document) {
        this.visitChildren(document);
    }

    @Override
    public void visit(BlockQuote blockQuote) {
        this.textContent.write('\u00ab');
        this.visitChildren(blockQuote);
        this.textContent.resetBlock();
        this.textContent.write('\u00bb');
        this.textContent.block();
    }

    @Override
    public void visit(BulletList bulletList) {
        this.textContent.pushTight(bulletList.isTight());
        this.listHolder = new BulletListHolder(this.listHolder, bulletList);
        this.visitChildren(bulletList);
        this.textContent.popTight();
        this.textContent.block();
        this.listHolder = this.listHolder.getParent();
    }

    @Override
    public void visit(Code code) {
        this.textContent.write('\"');
        this.textContent.write(code.getLiteral());
        this.textContent.write('\"');
    }

    @Override
    public void visit(FencedCodeBlock fencedCodeBlock) {
        String literal = CoreTextContentNodeRenderer.stripTrailingNewline(fencedCodeBlock.getLiteral());
        if (this.stripNewlines()) {
            this.textContent.writeStripped(literal);
        } else {
            this.textContent.write(literal);
        }
        this.textContent.block();
    }

    @Override
    public void visit(HardLineBreak hardLineBreak) {
        if (this.stripNewlines()) {
            this.textContent.whitespace();
        } else {
            this.textContent.line();
        }
    }

    @Override
    public void visit(Heading heading) {
        this.visitChildren(heading);
        if (this.stripNewlines()) {
            this.textContent.write(": ");
        } else {
            this.textContent.block();
        }
    }

    @Override
    public void visit(ThematicBreak thematicBreak) {
        if (!this.stripNewlines()) {
            this.textContent.write("***");
        }
        this.textContent.block();
    }

    @Override
    public void visit(HtmlInline htmlInline) {
        this.writeText(htmlInline.getLiteral());
    }

    @Override
    public void visit(HtmlBlock htmlBlock) {
        this.writeText(htmlBlock.getLiteral());
    }

    @Override
    public void visit(Image image) {
        this.writeLink(image, image.getTitle(), image.getDestination());
    }

    @Override
    public void visit(IndentedCodeBlock indentedCodeBlock) {
        String literal = CoreTextContentNodeRenderer.stripTrailingNewline(indentedCodeBlock.getLiteral());
        if (this.stripNewlines()) {
            this.textContent.writeStripped(literal);
        } else {
            this.textContent.write(literal);
        }
        this.textContent.block();
    }

    @Override
    public void visit(Link link) {
        this.writeLink(link, link.getTitle(), link.getDestination());
    }

    @Override
    public void visit(ListItem listItem) {
        if (this.listHolder != null && this.listHolder instanceof OrderedListHolder) {
            OrderedListHolder orderedListHolder = (OrderedListHolder)this.listHolder;
            String marker = orderedListHolder.getCounter() + orderedListHolder.getDelimiter();
            String spaces = " ";
            this.textContent.write(marker);
            this.textContent.write(spaces);
            this.textContent.pushPrefix(CoreTextContentNodeRenderer.repeat(" ", marker.length() + spaces.length()));
            this.visitChildren(listItem);
            this.textContent.block();
            this.textContent.popPrefix();
            orderedListHolder.increaseCounter();
        } else if (this.listHolder != null && this.listHolder instanceof BulletListHolder) {
            BulletListHolder bulletListHolder = (BulletListHolder)this.listHolder;
            if (!this.stripNewlines()) {
                String marker = bulletListHolder.getMarker();
                String spaces = " ";
                this.textContent.write(marker);
                this.textContent.write(spaces);
                this.textContent.pushPrefix(CoreTextContentNodeRenderer.repeat(" ", marker.length() + spaces.length()));
            }
            this.visitChildren(listItem);
            this.textContent.block();
            if (!this.stripNewlines()) {
                this.textContent.popPrefix();
            }
        }
    }

    @Override
    public void visit(OrderedList orderedList) {
        this.textContent.pushTight(orderedList.isTight());
        this.listHolder = new OrderedListHolder(this.listHolder, orderedList);
        this.visitChildren(orderedList);
        this.textContent.popTight();
        this.textContent.block();
        this.listHolder = this.listHolder.getParent();
    }

    @Override
    public void visit(Paragraph paragraph) {
        this.visitChildren(paragraph);
        this.textContent.block();
    }

    @Override
    public void visit(SoftLineBreak softLineBreak) {
        if (this.stripNewlines()) {
            this.textContent.whitespace();
        } else {
            this.textContent.line();
        }
    }

    @Override
    public void visit(Text text) {
        this.writeText(text.getLiteral());
    }

    @Override
    protected void visitChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }

    private void writeText(String text) {
        if (this.stripNewlines()) {
            this.textContent.writeStripped(text);
        } else {
            this.textContent.write(text);
        }
    }

    private void writeLink(Node node, String title, String destination) {
        boolean hasDestination;
        boolean hasChild = node.getFirstChild() != null;
        boolean hasTitle = title != null && !title.equals(destination);
        boolean bl = hasDestination = destination != null && !destination.equals("");
        if (hasChild) {
            this.textContent.write('\"');
            this.visitChildren(node);
            this.textContent.write('\"');
            if (hasTitle || hasDestination) {
                this.textContent.whitespace();
                this.textContent.write('(');
            }
        }
        if (hasTitle) {
            this.textContent.write(title);
            if (hasDestination) {
                this.textContent.colon();
                this.textContent.whitespace();
            }
        }
        if (hasDestination) {
            this.textContent.write(destination);
        }
        if (hasChild && (hasTitle || hasDestination)) {
            this.textContent.write(')');
        }
    }

    private boolean stripNewlines() {
        return this.context.lineBreakRendering() == LineBreakRendering.STRIP;
    }

    private static String stripTrailingNewline(String s) {
        if (s.endsWith("\n")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static String repeat(String s, int count) {
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    private static class BulletListHolder
    extends ListHolder {
        private final String marker;

        public BulletListHolder(ListHolder parent, BulletList list) {
            super(parent);
            this.marker = list.getMarker();
        }

        public String getMarker() {
            return this.marker;
        }
    }

    private static abstract class ListHolder {
        private final ListHolder parent;

        ListHolder(ListHolder parent) {
            this.parent = parent;
        }

        public ListHolder getParent() {
            return this.parent;
        }
    }

    private static class OrderedListHolder
    extends ListHolder {
        private final String delimiter;
        private int counter;

        public OrderedListHolder(ListHolder parent, OrderedList list) {
            super(parent);
            this.delimiter = list.getMarkerDelimiter() != null ? list.getMarkerDelimiter() : ".";
            this.counter = list.getMarkerStartNumber() != null ? list.getMarkerStartNumber() : 1;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        public int getCounter() {
            return this.counter;
        }

        public void increaseCounter() {
            ++this.counter;
        }
    }
}

