/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.ui.internal.tabs.processor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.xsl.internal.debug.ui.AbstractTableBlock;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.jaxp.debug.ui.internal.tabs.processor.AttributeDialog;
import org.eclipse.wst.xsl.jaxp.debug.ui.internal.tabs.processor.Messages;
import org.eclipse.wst.xsl.jaxp.launching.IAttribute;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorType;
import org.eclipse.wst.xsl.jaxp.launching.JAXPRuntime;
import org.eclipse.wst.xsl.jaxp.launching.LaunchAttributes;
import org.eclipse.wst.xsl.launching.config.LaunchAttribute;

public class AttributesBlock
extends AbstractTableBlock {
    private Table table;
    private TableViewer tViewer;
    private LaunchAttributes attributes;
    private Button removeButton;
    private Map<String, IAttribute> attributeUris = new HashMap<String, IAttribute>();

    public AttributesBlock() {
        IProcessorType[] iProcessorTypeArray = JAXPRuntime.getProcessorTypes();
        int n = iProcessorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessorType type = iProcessorTypeArray[n2];
            IAttribute[] iAttributeArray = type.getAttributes();
            int n3 = iAttributeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAttribute attribute = iAttributeArray[n4];
                this.attributeUris.put(attribute.getURI(), attribute);
                ++n4;
            }
            ++n2;
        }
    }

    protected IDialogSettings getDialogSettings() {
        return XSLDebugUIPlugin.getDefault().getDialogSettings();
    }

    protected String getQualifier() {
        return "org.eclipse.wst.xsl.jaxp.debug.ui." + ((Object)((Object)this)).getClass().getCanonicalName();
    }

    protected Table getTable() {
        return this.table;
    }

    public void createControl(Composite parent) {
        TabItem item = new TabItem((TabFolder)parent, 0);
        item.setText(Messages.getString("AttributesBlock.0"));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        item.setControl((Control)composite);
        this.table = new Table(composite, 68098);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    AttributesBlock.this.performRemove();
                }
            }
        });
        TableColumn tc1 = new TableColumn(this.table, 0);
        tc1.setText(Messages.getString("AttributesBlock.2"));
        tc1.setWidth(350);
        tc1.setResizable(true);
        TableColumn tc2 = new TableColumn(this.table, 0);
        tc2.setText(Messages.getString("AttributesBlock.7"));
        tc2.setWidth(50);
        tc2.setResizable(true);
        Composite buttonComp = new Composite(composite, 4);
        buttonComp.setLayoutData((Object)new GridData(4, 128, false, false));
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        buttonComp.setLayout((Layout)gl);
        Button addButton = new Button(buttonComp, 8);
        addButton.setText(Messages.getString("AttributesBlock.8"));
        addButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AttributeDialog dialog = new AttributeDialog(AttributesBlock.this.getShell(), AttributesBlock.this.attributes);
                if (dialog.open() == 0) {
                    List<IAttribute> newAttributes = dialog.getAttributes();
                    LaunchAttribute first = null;
                    for (IAttribute attribute : newAttributes) {
                        LaunchAttribute att = new LaunchAttribute(attribute.getURI(), "string", null);
                        if (first == null) {
                            first = att;
                        }
                        AttributesBlock.this.attributes.addAttribute(att);
                    }
                    if (newAttributes.size() > 0) {
                        AttributesBlock.this.tViewer.refresh();
                        AttributesBlock.this.tViewer.setSelection((ISelection)new StructuredSelection(first), true);
                        AttributesBlock.this.tViewer.editElement((Object)first, 1);
                        AttributesBlock.this.updateLaunchConfigurationDialog();
                    }
                }
            }
        });
        this.removeButton = new Button(buttonComp, 8);
        this.removeButton.setText(Messages.getString("AttributesBlock.14"));
        this.removeButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AttributesBlock.this.performRemove();
            }
        });
        this.setControl((Control)this.table);
        this.tViewer = new TableViewer(this.table);
        this.tViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return AttributesBlock.this.attributes.getAttributes().toArray(new LaunchAttribute[0]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                AttributesBlock.this.attributes = (LaunchAttributes)newInput;
            }
        });
        this.tViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                LaunchAttribute a1 = (LaunchAttribute)e1;
                LaunchAttribute a2 = (LaunchAttribute)e2;
                return a1.uri.compareTo(a2.uri);
            }
        });
        this.tViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AttributesBlock.this.updateRemoveButton();
            }
        });
        TableViewerColumn tvc1 = new TableViewerColumn(this.tViewer, tc1);
        tvc1.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                LaunchAttribute tv = (LaunchAttribute)cell.getElement();
                cell.setText(tv.uri);
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }

            public String getToolTipText(Object element) {
                LaunchAttribute tv = (LaunchAttribute)element;
                return ((IAttribute)AttributesBlock.this.attributeUris.get(tv.uri)).getDescription();
            }
        });
        TableViewerColumn tvc2 = new TableViewerColumn(this.tViewer, tc2);
        tvc2.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                LaunchAttribute tv = (LaunchAttribute)cell.getElement();
                cell.setText(tv.value);
            }
        });
        tvc2.setEditingSupport(new EditingSupport((ColumnViewer)this.tViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)AttributesBlock.this.table);
            }

            protected Object getValue(Object element) {
                LaunchAttribute tv = (LaunchAttribute)element;
                return tv.value == null ? "" : tv.value;
            }

            protected void setValue(Object element, Object value) {
                LaunchAttribute tv = (LaunchAttribute)element;
                tv.setValue((String)value);
                AttributesBlock.this.updateLaunchConfigurationDialog();
                AttributesBlock.this.tViewer.update((Object)tv, null);
            }
        });
        this.restoreColumnSettings();
    }

    protected void updateRemoveButton() {
        this.removeButton.setEnabled(!this.tViewer.getSelection().isEmpty());
    }

    public String getName() {
        return Messages.getString("AttributesBlock.16");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private void initializeAttributesFromStorage(ILaunchConfiguration configuration) throws CoreException {
        String s = configuration.getAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_ATTRIBUTES", null);
        this.attributes = s != null && s.length() > 0 ? LaunchAttributes.fromXML((InputStream)new ByteArrayInputStream(s.getBytes())) : new LaunchAttributes();
        this.tViewer.setInput((Object)this.attributes);
        this.updateRemoveButton();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.initializeAttributesFromStorage(configuration);
        }
        catch (CoreException e) {
            XSLDebugUIPlugin.log((CoreException)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        try {
            String xml = this.attributes.toXML();
            configuration.setAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_ATTRIBUTES", xml);
        }
        catch (ParserConfigurationException e) {
            XSLDebugUIPlugin.log((Exception)e);
        }
        catch (IOException e) {
            XSLDebugUIPlugin.log((Exception)e);
        }
        catch (TransformerException e) {
            XSLDebugUIPlugin.log((Exception)e);
        }
    }

    private void performRemove() {
        IStructuredSelection sel = (IStructuredSelection)this.tViewer.getSelection();
        for (LaunchAttribute att : sel) {
            this.attributes.removeAtribute(att.uri);
        }
        this.tViewer.refresh();
        this.updateLaunchConfigurationDialog();
    }
}

