/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;

public class BP2416
extends AssertionProcessVisitor {
    private final WSDLValidatorImpl validator;
    private static final String NS_LIST_KEY = "namespaces";

    public BP2416(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    private void checkNamespace(QName qname, WSDLTraversalContext ctx) {
        List namespaces;
        String namespace;
        if (qname != null && (namespace = qname.getNamespaceURI()) != null && !(namespaces = (List)ctx.getParameter(NS_LIST_KEY)).contains(namespace)) {
            this.result = "failed";
            this.failureDetailMessage = namespace;
            ctx.cancelProcessing();
        }
    }

    @Override
    public void visit(Port port, Object parent, WSDLTraversalContext ctx) {
        Binding binding;
        if (port != null && (binding = port.getBinding()) != null) {
            this.checkNamespace(binding.getQName(), ctx);
        }
    }

    @Override
    public void visit(Binding binding, Object parent, WSDLTraversalContext ctx) {
        PortType pType;
        if (binding != null && (pType = binding.getPortType()) != null) {
            this.checkNamespace(pType.getQName(), ctx);
        }
    }

    @Override
    public void visit(Operation operation, Object parent, WSDLTraversalContext ctx) {
        if (operation != null) {
            Output output;
            Input input = operation.getInput();
            if (input != null && input.getMessage() != null) {
                this.checkNamespace(input.getMessage().getQName(), ctx);
            }
            if ((output = operation.getOutput()) != null && output.getMessage() != null) {
                this.checkNamespace(output.getMessage().getQName(), ctx);
            }
            Map faults = operation.getFaults();
            for (Fault fault : faults.values()) {
                if (fault.getMessage() == null) continue;
                this.checkNamespace(fault.getMessage().getQName(), ctx);
            }
        }
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        List namespaces = this.validator.getWSDLTargetNamespaceList(definition);
        HashMap<String, List> params = new HashMap<String, List>();
        params.put(NS_LIST_KEY, namespaces);
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitOperation(true);
        traversal.visitBinding(true);
        traversal.visitMessage(true);
        traversal.visitPort(true);
        traversal.ignoreImport();
        traversal.ignoreReferences();
        traversal.traverse(definition, params);
        if (this.result.equals("failed")) {
            this.validator.createFailureDetail(this.failureDetailMessage, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

