/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.editors.SimpleGraphicalEditor;
import org.eclipse.jst.pagedesigner.utils.SelectionHelper;
import org.eclipse.swt.custom.StyledText;

public class SelectionSynchronizer
implements ISelectionChangedListener {
    private boolean _firingChange = false;
    private SimpleGraphicalEditor _editor;

    public SelectionSynchronizer(SimpleGraphicalEditor editor) {
        this._editor = editor;
    }

    protected boolean statusCheckOk() {
        try {
            StyledText text = this._editor.getHTMLEditor().getTextEditor().getTextViewer().getTextWidget();
            return text != null && !text.isDisposed();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!this._firingChange) {
            if (!this.statusCheckOk()) {
                return;
            }
            this._firingChange = true;
            try {
                ITextSelection srcselection = SelectionHelper.convertFromDesignSelectionToTextSelection(selection);
                this._editor.getHTMLEditor().getTextEditor().selectAndReveal(srcselection.getOffset(), srcselection.getLength());
            }
            finally {
                this._firingChange = false;
            }
        }
    }

    public void textSelectionChanged(int start, int end) {
        if (!this.htmlEditorIsInSourceOnlyMode() && !this._firingChange) {
            try {
                ITextSelection sel;
                this._firingChange = true;
                if (start == end && (sel = (ITextSelection)this._editor.getHTMLEditor().getTextEditor().getSelectionProvider().getSelection()).getLength() != 0) {
                    return;
                }
                if (start > end) {
                    int temp = start;
                    start = end;
                    end = temp;
                }
                int offset = start;
                int length = end - start;
                ITextSelection oldSelection = SelectionHelper.convertFromDesignSelectionToTextSelection(this._editor.getGraphicViewer().getSelection());
                if (oldSelection != null && oldSelection.getOffset() == offset && oldSelection.getLength() == length) {
                    return;
                }
                ISelection selection = SelectionHelper.convertToDesignerSelection(this._editor.getGraphicViewer(), offset, length);
                this._editor.getGraphicViewer().setSelection(selection);
            }
            finally {
                this._firingChange = false;
            }
        }
    }

    protected boolean htmlEditorIsInSourceOnlyMode() {
        HTMLEditor htmlEditor;
        boolean ret = false;
        if (this._editor != null && (htmlEditor = this._editor.getHTMLEditor()) != null) {
            ret = htmlEditor.getDesignerMode() == 3;
        }
        return ret;
    }
}

