/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.StringToObjectMapImpl;
import org.eclipse.e4.ui.model.application.impl.StringToStringMapImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class UIEventPublisher
extends EContentAdapter {
    private final IEclipseContext context;

    public UIEventPublisher(IEclipseContext e4Context) {
        this.context = e4Context;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.isTouch()) {
            return;
        }
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        String topic = this.formatData(notification, argMap);
        if (topic != null) {
            IEventBroker eventManager = (IEventBroker)this.context.get(IEventBroker.class);
            eventManager.send(topic, argMap);
        }
    }

    private String formatData(Notification notification, Map<String, Object> argMap) {
        MApplicationElement appElement = null;
        EStructuralFeature feature = null;
        String attributeName = null;
        String topic = null;
        Object notifier = notification.getNotifier();
        Map.Entry<String, Object> oldValue = null;
        Map.Entry<String, Object> newValue = null;
        Object position = null;
        if (notifier instanceof MApplicationElement) {
            appElement = (MApplicationElement)notifier;
            feature = (EStructuralFeature)notification.getFeature();
            attributeName = feature.getName();
            topic = this.getTopic(feature, this.getEventType(notification));
            switch (notification.getEventType()) {
                case 7: {
                    oldValue = notification.getOldValue();
                    newValue = notification.getNewValue();
                    position = notification.getPosition();
                    break;
                }
                case 5: {
                    newValue = notification.getNewValue();
                    position = notification.getPosition();
                    break;
                }
                case 6: {
                    oldValue = notification.getOldValue();
                    position = notification.getNewValue();
                    break;
                }
                case 3: 
                case 4: {
                    oldValue = notification.getOldValue();
                    newValue = notification.getNewValue();
                    position = notification.getPosition();
                    break;
                }
                case 1: 
                case 2: {
                    oldValue = notification.getOldValue();
                    newValue = notification.getNewValue();
                    break;
                }
                default: {
                    ILog.of(((Object)((Object)this)).getClass()).error(((Object)((Object)this)).getClass().getName() + ": unhandled EMF Notification code: " + notification.getEventType());
                    break;
                }
            }
        } else if (notifier instanceof StringToObjectMapImpl) {
            appElement = (MApplicationElement)((StringToObjectMapImpl)notifier).eContainer();
            String key = ((StringToObjectMapImpl)notifier).getKey();
            Object storedNewValue = appElement.getTransientData().get(key);
            Object notificationNewValue = notification.getNewValue();
            if (notificationNewValue != storedNewValue) {
                throw new IllegalArgumentException("A StringToObjectMap that was NOT MApplicationElement.transientData changed.  You must modify UIEventPublisher appropriately");
            }
            attributeName = "transientData";
            topic = this.getTopic(attributeName, this.getEventType(notification));
            oldValue = this.createMapEntry(key, notification.getOldValue());
            newValue = this.createMapEntry(key, notification.getNewValue());
        } else if (notifier instanceof StringToStringMapImpl) {
            appElement = (MApplicationElement)((StringToStringMapImpl)notifier).eContainer();
            String key = ((StringToStringMapImpl)notifier).getKey();
            Object storedNewValue = appElement.getPersistedState().get(key);
            Object notificationNewValue = notification.getNewValue();
            if (notificationNewValue != storedNewValue) {
                throw new IllegalArgumentException("A StringToStringMap that was NOT MApplicationElement.persistedState changed.  You must modify UIEventPublisher appropriately");
            }
            attributeName = "persistedState";
            topic = this.getTopic(attributeName, this.getEventType(notification));
            oldValue = this.createMapEntry(key, notification.getOldValue());
            newValue = this.createMapEntry(key, notification.getNewValue());
        } else {
            return null;
        }
        argMap.put("EventType", this.getEventType(notification));
        argMap.put("ChangedElement", appElement);
        argMap.put("AttName", attributeName);
        if (notification.getEventType() == 1 || notification.getEventType() == 7 || notification.getEventType() == 3 || notification.getEventType() == 5 || notification.getEventType() == 4 || notification.getEventType() == 6) {
            if (newValue != null) {
                argMap.put("NewValue", newValue);
            }
            if (oldValue != null) {
                argMap.put("OldValue", oldValue);
            }
            if (position != null) {
                argMap.put("Position", position);
            }
        }
        if (appElement instanceof MUIElement) {
            argMap.put("Widget", ((MUIElement)appElement).getWidget());
        }
        return topic;
    }

    private String getEventType(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                return "ADD";
            }
            case 5: {
                return "ADD_MANY";
            }
            case 4: {
                return "REMOVE";
            }
            case 6: {
                return "REMOVE_MANY";
            }
            case 7: {
                return "MOVE";
            }
            case 1: {
                return "SET";
            }
        }
        return "UNKNOWN";
    }

    private Map.Entry<String, Object> createMapEntry(final String key, final Object value) {
        return new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Object getValue() {
                return value;
            }

            @Override
            public Object setValue(Object value2) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private String getTopic(EStructuralFeature eFeature, String type) {
        EClass eContainingClass = eFeature.getEContainingClass();
        return "org/eclipse/e4/ui/model/" + eContainingClass.getEPackage().getName() + "/" + eContainingClass.getName() + "/" + eFeature.getName() + "/" + type;
    }

    private String getTopic(String attributeName, String type) {
        String topicBase = "org/eclipse/e4/ui/model/application/ApplicationElement/";
        return topicBase + attributeName + "/" + type;
    }
}

