/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.services.FilterService;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;

@ServiceProvider(value="Services available for Resources and URIs")
public class ResourceServices
extends AbstractServiceProvider {
    @Override
    protected IService<Method> getService(Method method, boolean forWorkspace) {
        if ("getContents".equals(method.getName())) {
            return new GetContentsService(method, this, forWorkspace);
        }
        return new JavaMethodService(method, this, forWorkspace);
    }

    @Documentation(value="Returns the Resource containing the given EObject. This service is equivalent to a direct call to EObject#eResource().", params={@Param(name="eObject", value="The EObject")}, result="The Resource containing the given EObject.")
    public Resource eResource(EObject eObject) {
        return eObject.eResource();
    }

    @Documentation(value="Returns the URI of the given Resource. This service is equivalent to a direct call to Resource#getURI()", params={@Param(name="resource", value="The Resource which URI we seek")}, result="The URI of the given Resource.")
    public URI getURI(Resource resource) {
        return resource.getURI();
    }

    @Documentation(value="Returns the direct content of the given Resource. This service is equivalent to a direct call to Resource#getContents()", params={@Param(name="resource", value="The Resource which contents we seek")}, result="The direct content of the given Resource.")
    public List<EObject> getContents(Resource resource) {
        return new ArrayList<EObject>((Collection<EObject>)resource.getContents());
    }

    @Documentation(value="Returns the EObjects of the given type from the direct content of the given Resource.", params={@Param(name="resource", value="The Resource which filtered contents we seek"), @Param(name="type", value="The type that the returned EObjects must match")}, result="The EObjects from the direct content of the given Resource that match the given type.")
    public List<EObject> getContents(Resource resource, EClass type) {
        ArrayList<EObject> res = new ArrayList<EObject>();
        for (EObject eObj : resource.getContents()) {
            if (!type.isInstance((Object)eObj)) continue;
            res.add(eObj);
        }
        return res;
    }

    @Documentation(value="Returns the EObjects from the given Resource with the given URI fragment.", params={@Param(name="resource", value="The Resource where to look for the EObject"), @Param(name="uriFragment", value="The URI fragment of the EObject in the Resource (can be an ID)")}, result="The EObjects from the given Resource with the given URI fragment.")
    public EObject getEObject(Resource resource, String uriFragment) {
        EObject res = resource != null && uriFragment != null ? resource.getEObject(uriFragment) : null;
        return res;
    }

    @Documentation(value="Returns the URI fragment from the given EObject in its Resource.", params={@Param(name="eObject", value="The EObject")}, result="The URI fragment from the given EObject in its Resource or null if not in a resource.")
    public String getURIFragment(EObject eObject) {
        Resource eResource;
        String res = eObject != null ? ((eResource = eObject.eResource()) != null ? eResource.getURIFragment(eObject) : null) : null;
        return res;
    }

    @Documentation(value="Returns the last segment of the given URI. This service is equivalent to a direct call to URI#lastSegment()", params={@Param(name="uri", value="The URI")}, result="The last segment of the given URI.")
    public String lastSegment(URI uri) {
        return uri.lastSegment();
    }

    @Documentation(value="Returns the extension of the file referred to by the given URI. This service is equivalent to a direct call to URI#fileExtension()", params={@Param(name="uri", value="The URI")}, result="The extension of the file referred to by the given URI.")
    public String fileExtension(URI uri) {
        return uri.fileExtension();
    }

    @Documentation(value="Returns \"true\" if the given URI is a platform resource URI. This service is equivalent to a direct call to URI#isPlatformResource()", params={@Param(name="uri", value="The URI")}, result="\"true\" if the given URI is a platform resource URI, \"false\" otherwise.")
    public Boolean isPlatformResource(URI uri) {
        return uri.isPlatformResource();
    }

    @Documentation(value="Returns \"true\" if the given URI is a platform plugin URI. This service is equivalent to a direct call to URI#isPlatformPlugin()", params={@Param(name="uri", value="The URI")}, result="\"true\" if the given URI is a platform plugin URI, \"false\" otherwise.")
    public Boolean isPlatformPlugin(URI uri) {
        return uri.isPlatformPlugin();
    }

    private static final class GetContentsService
    extends FilterService {
        private GetContentsService(Method serviceMethod, Object serviceInstance, boolean forWorkspace) {
            super(serviceMethod, serviceInstance, forWorkspace);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject())));
            } else if (argTypes.size() == 2) {
                result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
            }
            return result;
        }
    }
}

