/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.validation;

import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.parsley.validation.DiagnosticUtil;
import org.eclipse.emf.parsley.validation.IssueReporter;

public class LogIssueReporter
implements IssueReporter {
    private static final Logger LOGGER = Logger.getLogger(LogIssueReporter.class);
    @Inject
    private DiagnosticUtil diagnosticUtil;

    @Override
    public List<Diagnostic> report(Diagnostic diagnostic) {
        List<Diagnostic> diagnostics = this.diagnosticUtil.flatten(diagnostic);
        for (Diagnostic d : diagnostics) {
            int severity = d.getSeverity();
            if (severity == 4) {
                this.logError(d);
                continue;
            }
            if (severity == 2) {
                this.logWarning(d);
                continue;
            }
            this.logInfo(d);
        }
        return diagnostics;
    }

    protected void logInfo(Diagnostic d) {
        LOGGER.info((Object)this.diagnosticUtil.format(d));
    }

    protected void logWarning(Diagnostic d) {
        LOGGER.warn((Object)this.diagnosticUtil.format(d));
    }

    protected void logError(Diagnostic d) {
        LOGGER.error((Object)this.diagnosticUtil.format(d));
    }
}

