/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.bcpg.PaddingPacket;
import org.bouncycastle.crypto.CryptoServicesRegistrar;

public class PGPPadding {
    private PaddingPacket p;
    public static final int MIN_PADDING_LEN = 16;
    public static final int MAX_PADDING_LEN = 255;

    public PGPPadding(BCPGInputStream bCPGInputStream) throws IOException {
        Packet packet = bCPGInputStream.readPacket();
        if (!(packet instanceof PaddingPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        this.p = (PaddingPacket)packet;
    }

    public PGPPadding() {
        this(CryptoServicesRegistrar.getSecureRandom());
    }

    public PGPPadding(SecureRandom secureRandom) {
        this(16 + secureRandom.nextInt(240), secureRandom);
    }

    public PGPPadding(int n) {
        this(n, CryptoServicesRegistrar.getSecureRandom());
    }

    public PGPPadding(int n, SecureRandom secureRandom) {
        this.p = new PaddingPacket(n, secureRandom);
    }

    public byte[] getPadding() {
        return this.p.getPadding();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = BCPGOutputStream.wrap(outputStream);
        this.p.encode(bCPGOutputStream);
    }

    public byte[] getEncoded() throws IOException {
        return this.getEncoded(PacketFormat.ROUNDTRIP);
    }

    public byte[] getEncoded(PacketFormat packetFormat) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream((OutputStream)byteArrayOutputStream, packetFormat);
        this.encode(bCPGOutputStream);
        bCPGOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

