/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;

public class ProxyHelper {
    public static IProxyData getProxyData(String url, IProxyService proxyService) {
        if (proxyService != null) {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            return ProxyHelper.doGetProxyData(proxyService, uri);
        }
        return null;
    }

    public static IProxyData getProxyData(URI uri, IProxyService proxyService) {
        if (proxyService != null) {
            return ProxyHelper.doGetProxyData(proxyService, uri);
        }
        return null;
    }

    private static IProxyData doGetProxyData(IProxyService proxyService, URI uri) {
        if (uri.getHost() == null || uri.getScheme() == null) {
            return null;
        }
        IProxyData[] proxyData = proxyService.select(uri);
        if (proxyData == null) {
            return null;
        }
        IProxyData[] iProxyDataArray = proxyData;
        int n = proxyData.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData pd = iProxyDataArray[n2];
            if (pd != null && pd.getHost() != null) {
                return pd;
            }
            ++n2;
        }
        return null;
    }
}

