/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.properties.sections;

import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorCSHelpIds;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;
import org.eclipse.wst.wsdl.ui.internal.asd.properties.sections.NameSection;
import org.eclipse.wst.wsdl.ui.internal.util.ReferenceEditManagerHelper;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;

public class ParameterSection
extends NameSection {
    protected CLabel comboLabel;
    protected CCombo combo;
    protected boolean handleTypeScenario = true;
    protected ComponentReferenceEditManager parameterRefManager;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.createControlArea();
    }

    public void createControlArea() {
        this.comboLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_LABEL_TYPE);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        this.comboLabel.setLayoutData((Object)data);
        this.combo = this.getWidgetFactory().createCCombo(this.composite);
        this.combo.setBackground(this.composite.getBackground());
        this.combo.addListener(24, (Listener)this);
        this.combo.addListener(14, (Listener)this);
        this.combo.addListener(31, (Listener)this);
        this.combo.setLayoutData((Object)new GridData(768));
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.nameText.isFocusControl()) {
            return;
        }
        this.setListenerEnabled(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.combo, ASDEditorCSHelpIds.PROPERTIES_PART_ELEMENT_COMBO);
        if (this.handleTypeScenario) {
            this.refreshCombo();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.combo, ASDEditorCSHelpIds.PROPERTIES_PART_TYPE_COMBO);
        }
        this.setControlForegroundColor((Control)this.combo);
        this.setListenerEnabled(true);
    }

    protected void refreshCombo() {
        int index;
        IParameter param = null;
        Object model = this.getModel();
        this.setListenerEnabled(false);
        if (model instanceof IParameter) {
            param = (IParameter)model;
        }
        String name = "";
        String typeName = "";
        if (param != null) {
            name = param.getName();
            typeName = param.getComponentName();
        }
        if (!this.nameText.isFocusControl()) {
            this.nameText.setText(name);
        }
        this.combo.removeAll();
        this.combo.add(BROWSE_STRING);
        this.combo.add(NEW_STRING);
        ComponentReferenceEditManager editManager = this.getComponentReferenceEditManager();
        if (editManager != null) {
            ComponentSpecification[] specs = editManager.getQuickPicks();
            index = 0;
            while (index < specs.length) {
                this.combo.add(specs[index].getName());
                ++index;
            }
            specs = editManager.getHistory();
            index = 0;
            while (index < specs.length) {
                this.combo.add(specs[index].getName());
                ++index;
            }
        }
        String[] items = this.combo.getItems();
        index = 0;
        while (index < items.length) {
            if (items[index].equals(typeName)) break;
            ++index;
        }
        if (index < items.length) {
            this.combo.select(index);
        } else {
            this.combo.setText(typeName);
        }
        this.setListenerEnabled(true);
    }

    @Override
    public boolean shouldUseExtraSpace() {
        return false;
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this.combo) {
            if (this.isListenerEnabled() && !this.isInDoHandle) {
                if (event.type == 31) {
                    if (event.detail == 64 || event.detail == 32) {
                        this.isTraversing = true;
                    }
                } else {
                    this.isInDoHandle = true;
                    this.startDelayedEvent(event);
                    this.isInDoHandle = false;
                }
            }
        } else {
            super.handleEvent(event);
        }
    }

    @Override
    public void doHandleEvent(Event event) {
        String selectedItem;
        super.doHandleEvent(event);
        if (event.widget == this.combo && !this.combo.isDisposed() && this.shouldPerformComboSelection(event, selectedItem = this.combo.getItem(this.combo.getSelectionIndex()))) {
            this.handleComboSelection();
            this.refresh();
        }
    }

    protected void handleComboSelection() {
        String value = this.combo.getItem(this.combo.getSelectionIndex());
        IParameter parameter = (IParameter)this.getModel();
        if (value.equals(NEW_STRING)) {
            Command command = parameter.getSetTypeCommand("SetTypeAction_AddType");
            command.execute();
        } else if (value.equals(BROWSE_STRING)) {
            Command command = parameter.getSetTypeCommand("SetTypeAction_ExistingType");
            command.execute();
        } else {
            ComponentReferenceEditManager editManager = this.getComponentReferenceEditManager();
            ComponentSpecification spec = this.getComponentSpecificationForValue(value);
            if (spec != null) {
                editManager.modifyComponentReference((Object)parameter, spec);
            }
        }
    }

    protected ComponentReferenceEditManager getComponentReferenceEditManager() {
        if (this.parameterRefManager != null) {
            return this.parameterRefManager;
        }
        if (this.getModel() instanceof IASDObject) {
            this.parameterRefManager = ReferenceEditManagerHelper.getXSDTypeReferenceEditManager((IASDObject)this.getModel());
        } else {
            System.out.println("model" + this.getModel());
        }
        return this.parameterRefManager;
    }

    protected ComponentSpecification getComponentSpecificationForValue(String value) {
        ComponentReferenceEditManager editManager = this.getComponentReferenceEditManager();
        if (editManager != null) {
            ComponentSpecification[] history;
            ComponentSpecification[] quickPicks = editManager.getQuickPicks();
            if (quickPicks != null) {
                int i = 0;
                while (i < quickPicks.length) {
                    ComponentSpecification componentSpecification = quickPicks[i];
                    if (value.equals(componentSpecification.getName())) {
                        return componentSpecification;
                    }
                    ++i;
                }
            }
            if ((history = editManager.getHistory()) != null) {
                int i = 0;
                while (i < history.length) {
                    ComponentSpecification componentSpecification = history[i];
                    if (value.equals(componentSpecification.getName())) {
                        return componentSpecification;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.removeListener(24, (Listener)this);
            this.combo.removeListener(14, (Listener)this);
            this.combo.removeListener(31, (Listener)this);
        }
        super.dispose();
    }
}

