/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.generator.method;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.builder.IBuilderContext;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.IJavaSourceBuilder;
import org.eclipse.scout.sdk.core.java.builder.JavaBuilderContextFunction;
import org.eclipse.scout.sdk.core.java.builder.body.IMethodBodyBuilder;
import org.eclipse.scout.sdk.core.java.builder.body.MethodBodyBuilder;
import org.eclipse.scout.sdk.core.java.builder.comment.IJavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.java.builder.comment.JavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.java.builder.member.IMemberBuilder;
import org.eclipse.scout.sdk.core.java.builder.member.MemberBuilder;
import org.eclipse.scout.sdk.core.java.generator.IJavaElementGenerator;
import org.eclipse.scout.sdk.core.java.generator.annotation.AnnotationGenerator;
import org.eclipse.scout.sdk.core.java.generator.annotation.IAnnotationGenerator;
import org.eclipse.scout.sdk.core.java.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.java.generator.member.AbstractMemberGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.methodparam.IMethodParameterGenerator;
import org.eclipse.scout.sdk.core.java.generator.methodparam.MethodParameterGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.java.generator.typeparam.ITypeParameterGenerator;
import org.eclipse.scout.sdk.core.java.model.api.Flags;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.PropertyBean;
import org.eclipse.scout.sdk.core.java.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SourceRange;
import org.eclipse.scout.sdk.core.util.Strings;

public class MethodGenerator<TYPE extends IMethodGenerator<TYPE, BODY>, BODY extends IMethodBodyBuilder<?>>
extends AbstractMemberGenerator<TYPE>
implements IMethodGenerator<TYPE, BODY> {
    protected final List<IMethodParameterGenerator<?>> m_parameters;
    protected final List<ITypeParameterGenerator<?>> m_typeParameters;
    protected final List<JavaBuilderContextFunction<ITypeNameSupplier>> m_throwables;
    private JavaBuilderContextFunction<String> m_returnType;
    private ISourceGenerator<BODY> m_body;
    private boolean m_withOverrideIfNecessary;
    private IType m_overrideIfNecessaryDeclaringType;

    protected MethodGenerator() {
        this.m_parameters = new ArrayList();
        this.m_typeParameters = new ArrayList();
        this.m_throwables = new ArrayList<JavaBuilderContextFunction<ITypeNameSupplier>>();
    }

    protected MethodGenerator(IMethod method, IWorkingCopyTransformer transformer) {
        super(method, transformer);
        this.m_returnType = method.returnType().map(IType::reference).map(JavaBuilderContextFunction::create).orElse(null);
        this.m_typeParameters = method.typeParameters().map(p -> IWorkingCopyTransformer.transformTypeParameter(p, transformer)).flatMap(Optional::stream).collect(Collectors.toList());
        this.m_parameters = method.parameters().stream().map(mp -> IWorkingCopyTransformer.transformMethodParameter(mp, transformer)).flatMap(Optional::stream).collect(Collectors.toList());
        this.m_throwables = method.exceptionTypes().map(IType::name).map(ITypeNameSupplier::of).map(JavaBuilderContextFunction::create).collect(Collectors.toList());
        if (MethodGenerator.canHaveBody(method.flags())) {
            this.m_body = method.sourceOfBody().map(SourceRange::asCharSequence).map(ISourceGenerator::raw).orElse(null);
        }
        if (method.requireDeclaringType().isInterface()) {
            this.withFlags(this.flags() | 0x200);
        }
    }

    public static IMethodGenerator<?, ?> create() {
        return new MethodGenerator();
    }

    public static IMethodGenerator<?, ?> create(IMethod method, IWorkingCopyTransformer transformer) {
        return new MethodGenerator(method, transformer);
    }

    public static IMethodGenerator<?, ?> createGetter(IFieldGenerator<?> fieldGenerator) {
        JavaBuilderContextFunction<String> dataType = fieldGenerator.dataTypeFunc().orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot create getter for field because it has no data type.", (Object[])new Object[0]));
        String fieldName = ((IFieldGenerator)Ensure.notNull(fieldGenerator)).elementName().orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot create getter for field because it has no name.", (Object[])new Object[0]));
        return MethodGenerator.createGetterFunc(fieldName, dataType, 1);
    }

    public static IMethodGenerator<?, ?> createGetter(String fieldName, String dataType) {
        return MethodGenerator.createGetter(fieldName, dataType, 1);
    }

    public static IMethodGenerator<?, ?> createGetter(String fieldName, String dataType, int flags) {
        return MethodGenerator.createGetterFunc(fieldName, JavaBuilderContextFunction.create(dataType), flags);
    }

    public static <A extends IApiSpecification> IMethodGenerator<?, ?> createGetterFrom(String fieldName, Class<A> apiDefinition, Function<A, String> dataTypeFunction, int flags) {
        return MethodGenerator.createGetterFunc(fieldName, new ApiFunction<A, String>(apiDefinition, dataTypeFunction), flags);
    }

    public static IMethodGenerator<?, ?> createGetterFunc(String fieldName, Function<IJavaBuilderContext, String> dataTypeFunction, int flags) {
        String methodBaseName = MethodGenerator.getGetterSetterBaseName(fieldName);
        Object getter = ((IMethodGenerator)((IMethodGenerator)MethodGenerator.create().withFlags(flags)).withComment(IJavaElementCommentBuilder::appendDefaultElementComment)).withBody(b -> ((IMethodBodyBuilder)b.returnClause().append(fieldName)).semicolon());
        String constDataType = JavaBuilderContextFunction.orNull(dataTypeFunction).apply().orElse(null);
        if (constDataType != null) {
            return ((IMethodGenerator)getter.withElementName(PropertyBean.getterPrefixFor(constDataType) + methodBaseName)).withReturnType(constDataType);
        }
        return ((IMethodGenerator)getter.withElementNameFunc(c -> PropertyBean.getterPrefixFor((CharSequence)dataTypeFunction.apply((IJavaBuilderContext)c)) + methodBaseName)).withReturnTypeFunc(dataTypeFunction);
    }

    public static IMethodGenerator<?, ?> createSetter(IFieldGenerator<?> fieldGenerator) {
        JavaBuilderContextFunction<String> dataType = fieldGenerator.dataTypeFunc().orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot create setter for field because it has no data type.", (Object[])new Object[0]));
        return MethodGenerator.createSetter(((IFieldGenerator)Ensure.notNull(fieldGenerator)).elementName().orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot create setter for field because it has no name.", (Object[])new Object[0])), dataType, 1, null);
    }

    public static IMethodGenerator<?, ?> createSetter(String fieldName, String dataType) {
        return MethodGenerator.createSetter(fieldName, dataType, 1);
    }

    public static IMethodGenerator<?, ?> createSetter(String fieldName, String dataType, int flags) {
        return MethodGenerator.createSetter(fieldName, dataType, flags, null);
    }

    public static IMethodGenerator<?, ?> createSetter(String fieldName, String dataType, int flags, String paramNamePrefix) {
        return MethodGenerator.createSetter(fieldName, (IJavaBuilderContext c) -> dataType, flags, paramNamePrefix);
    }

    public static <A extends IApiSpecification> IMethodGenerator<?, ?> createSetter(String fieldName, Class<A> apiDefinition, Function<A, String> dataTypeFunction, int flags, String paramNamePrefix) {
        return MethodGenerator.createSetter(fieldName, new ApiFunction<A, String>(apiDefinition, dataTypeFunction), flags, paramNamePrefix);
    }

    public static IMethodGenerator<?, ?> createSetter(String fieldName, Function<IJavaBuilderContext, String> dataTypeFunction, int flags, String paramNamePrefix) {
        String setterBaseName = MethodGenerator.getGetterSetterBaseName(fieldName);
        String parameterName = MethodGenerator.getPrefixedMethodParameterName(paramNamePrefix, setterBaseName);
        return ((IMethodGenerator)((IMethodGenerator)((IMethodGenerator)MethodGenerator.create().withElementName("set" + setterBaseName)).withFlags(flags)).withReturnType("void").withParameter((IMethodParameterGenerator)MethodParameterGenerator.create().withDataTypeFunc(dataTypeFunction).withElementName(parameterName)).withComment(IJavaElementCommentBuilder::appendDefaultElementComment)).withBody(b -> ((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)b.append(fieldName)).equalSign()).append(parameterName)).semicolon());
    }

    protected static boolean canHaveBody(int methodFlags) {
        return (!Flags.isInterface(methodFlags) || Flags.isDefaultMethod(methodFlags)) && !Flags.isAbstract(methodFlags);
    }

    protected static String getGetterSetterBaseName(String fieldName) {
        StringBuilder sb = new StringBuilder((String)Ensure.notBlank((CharSequence)fieldName));
        if (sb.length() > 1 && sb.charAt(0) == 'm' && sb.charAt(1) == '_') {
            sb.delete(0, 2);
        }
        if (!sb.isEmpty()) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    protected static String getPrefixedMethodParameterName(String paramNamePrefix, String setterBaseName) {
        if (Strings.isBlank((CharSequence)paramNamePrefix)) {
            return Introspector.decapitalize(setterBaseName);
        }
        StringBuilder paramNameBuilder = new StringBuilder(paramNamePrefix.length() + setterBaseName.length());
        paramNameBuilder.append(Introspector.decapitalize(paramNamePrefix));
        paramNameBuilder.append(setterBaseName);
        return paramNameBuilder.toString();
    }

    @Override
    protected void build(IJavaSourceBuilder<?> builder) {
        IAnnotationGenerator<?> overrideAnnotation = this.createOverrideAnnotationIfNecessary(builder.context());
        this.withAnnotation(overrideAnnotation);
        try {
            super.build(builder);
            this.buildMethodSource(MemberBuilder.create(builder));
        }
        finally {
            if (overrideAnnotation != null) {
                this.withoutAnnotation((IAnnotationGenerator<?> a) -> a == overrideAnnotation);
            }
        }
    }

    protected IAnnotationGenerator<?> createOverrideAnnotationIfNecessary(IJavaBuilderContext context) {
        if (!this.isWithOverrideIfNecessary()) {
            return null;
        }
        String overrideFqn = Override.class.getName();
        if (this.annotations().anyMatch(a -> overrideFqn.equals(a.elementName(context).orElse(null)))) {
            return null;
        }
        if (!this.existsMethodInSuperHierarchy(context)) {
            return null;
        }
        return AnnotationGenerator.createOverride();
    }

    protected boolean existsMethodInSuperHierarchy(IJavaBuilderContext context) {
        String methodId = this.identifier(context);
        IType explicitDeclaringType = this.getOverrideIfNecessaryDeclaringType();
        if (explicitDeclaringType != null) {
            return explicitDeclaringType.directSuperTypes().anyMatch(t -> MethodGenerator.existsMethodInSuperHierarchy(t, methodId));
        }
        IJavaElementGenerator declaringGenerator = this.declaringGenerator().orElse(null);
        if (declaringGenerator instanceof ITypeGenerator) {
            ITypeGenerator declaringTypeGenerator = (ITypeGenerator)declaringGenerator;
            return MethodGenerator.existsMethodInSuperHierarchy(declaringTypeGenerator.getHierarchyType(context), methodId);
        }
        return false;
    }

    protected static boolean existsMethodInSuperHierarchy(IType t, String methodId) {
        return t.methods().withSuperTypes(true).withMethodIdentifier(methodId).existsAny();
    }

    protected void buildMethodSource(IMemberBuilder<?> builder) {
        int flags = this.flags();
        boolean isVarargs = Flags.isVarargs(flags);
        if (Flags.isDefaultMethod(flags &= 0xFFFFFF7F) || Flags.isInterface(flags)) {
            flags &= 0xFFFFFBFE;
        }
        builder.appendFlags(flags);
        builder.append(this.typeParameters(), "<", ", ", "> ");
        this.returnTypeFunc().ifPresent(t -> ((IMemberBuilder)builder.refFunc((Function<IJavaBuilderContext, CharSequence>)t)).space());
        builder.append(MethodGenerator.ensureValidJavaName(this.elementName(builder.context()).orElseThrow(() -> Ensure.newFail((CharSequence)"Method must have a name.", (Object[])new Object[0]))));
        if (isVarargs && !this.m_parameters.isEmpty()) {
            this.m_parameters.getLast().asVarargs();
        }
        builder.parenthesisOpen();
        builder.append(this.parameters(), null, ", ", null);
        builder.parenthesisClose();
        builder.references(this.throwablesFunc().map(af -> (ITypeNameSupplier)af.apply(builder.context())).filter(Objects::nonNull).map(ITypeNameSupplier::fqn).filter(Strings::hasText).distinct(), " throws ", ", ", null);
        if (MethodGenerator.canHaveBody(flags)) {
            this.buildBodySource(builder);
        } else {
            builder.semicolon();
        }
    }

    protected BODY createMethodBodyBuilder(ISourceBuilder<?> inner) {
        return this.createMethodBodyBuilder(inner, this);
    }

    protected BODY createMethodBodyBuilder(ISourceBuilder<?> inner, IMethodGenerator<?, ?> surroundingMethod) {
        return (BODY)MethodBodyBuilder.create(inner, surroundingMethod);
    }

    protected void buildBodySource(IMemberBuilder<?> builder) {
        int lastNl;
        boolean endsWithNl;
        boolean srcAvailable;
        ((IMemberBuilder)builder.space()).blockStart();
        String lineDelimiter = builder.context().lineDelimiter();
        StringBuilder bodySrc = this.body().map(g -> g.toSource(this::createMethodBodyBuilder, (IBuilderContext)builder.context())).orElse(new StringBuilder(lineDelimiter));
        boolean bl = srcAvailable = bodySrc.length() > lineDelimiter.length();
        if (srcAvailable && !bodySrc.substring(0, lineDelimiter.length()).equals(lineDelimiter)) {
            builder.nl();
        }
        builder.append(bodySrc);
        boolean bl2 = endsWithNl = srcAvailable && bodySrc.substring(bodySrc.length() - lineDelimiter.length(), bodySrc.length()).equals(lineDelimiter);
        if (!endsWithNl && ((lastNl = bodySrc.lastIndexOf(lineDelimiter)) < 0 || Strings.hasText((CharSequence)bodySrc.substring(lastNl)))) {
            builder.append(lineDelimiter);
        }
        builder.blockEnd();
    }

    @Override
    protected IJavaElementCommentBuilder<?> createCommentBuilder(ISourceBuilder<?> builder) {
        IJavaSourceBuilder javaSourceBuilder = (IJavaSourceBuilder)builder;
        IJavaBuilderContext context = javaSourceBuilder.context();
        if (PropertyBean.getterName(this, context).isPresent()) {
            return JavaElementCommentBuilder.createForMethodGetter(builder, this);
        }
        if (PropertyBean.setterName(this, context).isPresent()) {
            return JavaElementCommentBuilder.createForMethodSetter(builder, this);
        }
        return JavaElementCommentBuilder.createForMethod(builder, this);
    }

    @Override
    public String identifier(IJavaBuilderContext context, boolean includeTypeArguments) {
        List methodParamTypes = this.m_parameters.stream().map(param -> param.reference(context, !includeTypeArguments)).collect(Collectors.toList());
        return JavaTypes.createMethodIdentifier(this.elementName(context).orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot calculate method identifier because the method name is missing.", (Object[])new Object[0])), methodParamTypes);
    }

    @Override
    public String identifier(IJavaBuilderContext context) {
        return this.identifier(context, false);
    }

    @Override
    public boolean isConstructor() {
        return this.returnTypeFunc().isEmpty();
    }

    @Override
    public Optional<String> returnType() {
        return this.returnTypeFunc().flatMap(JavaBuilderContextFunction::apply);
    }

    @Override
    public Optional<String> returnType(IJavaBuilderContext context) {
        return this.returnTypeFunc().map(f -> (String)f.apply(context));
    }

    @Override
    public Optional<JavaBuilderContextFunction<String>> returnTypeFunc() {
        return Optional.ofNullable(this.m_returnType);
    }

    @Override
    public TYPE withReturnType(String returnType) {
        this.m_returnType = JavaBuilderContextFunction.orNull(returnType);
        return (TYPE)((IMethodGenerator)this.thisInstance());
    }

    @Override
    public <A extends IApiSpecification> TYPE withReturnTypeFrom(Class<A> apiDefinition, Function<A, String> returnTypeSupplier) {
        this.m_returnType = new ApiFunction<A, String>(apiDefinition, returnTypeSupplier);
        return (TYPE)((IMethodGenerator)this.thisInstance());
    }

    @Override
    public TYPE withReturnTypeFunc(Function<IJavaBuilderContext, String> returnTypeSupplier) {
        this.m_returnType = JavaBuilderContextFunction.orNull(returnTypeSupplier);
        return (TYPE)((IMethodGenerator)this.thisInstance());
    }

    @Override
    public Stream<String> throwables() {
        return this.throwablesFunc().map(JavaBuilderContextFunction::apply).flatMap(Optional::stream).map(ITypeNameSupplier::fqn);
    }

    @Override
    public Stream<JavaBuilderContextFunction<ITypeNameSupplier>> throwablesFunc() {
        return this.m_throwables.stream();
    }

    @Override
    public TYPE withThrowable(String throwableFqn) {
        if (Strings.hasText((CharSequence)throwableFqn)) {
            this.m_throwables.add(JavaBuilderContextFunction.create(ITypeNameSupplier.of(throwableFqn)));
        }
        return (TYPE)((IMethodGenerator)this.thisInstance());
    }

    @Override
    public <A extends IApiSpecification> TYPE withThrowableFrom(Class<A> apiDefinition, Function<A, ITypeNameSupplier> throwableSupplier) {
        if (throwableSupplier != null) {
            this.m_throwables.add(new ApiFunction<A, ITypeNameSupplier>(apiDefinition, throwableSupplier));
        }
        return (TYPE)((IMethodGenerator)this.thisInstance());
    }

    @Override
    public TYPE withThrowableFunc(Function<IJavaBuilderContext, ITypeNameSupplier> throwableSupplier) {
        if (throwableSupplier != null) {
            this.m_throwables.add(JavaBuilderContextFunction.create(throwableSupplier));
        }
        return (TYPE)((IMethodGenerator)this.thisInstance());
    }

    @Override
    public TYPE withoutThrowable(CharSequence fqn) {
        return this.withoutThrowable(ITypeNameSupplier.of(fqn));
    }

    @Override
    public TYPE withoutThrowable(ITypeNameSupplier cns) {
        String fqnToRemove = cns == null ? null : cns.fqn();
        return this.withoutThrowable((JavaBuilderContextFunction<ITypeNameSupplier> f) -> f.apply().map(ITypeNameSupplier::fqn).filter(Predicate.isEqual(fqnToRemove)).isPresent());
    }

    @Override
    public TYPE withoutThrowable(Predicate<JavaBuilderContextFunction<ITypeNameSupplier>> toRemoveFilter) {
        if (toRemoveFilter == null) {
            this.m_throwables.clear();
        } else {
            this.m_throwables.removeIf(toRemoveFilter);
        }
        return (TYPE)((IMethodGenerator)this.thisInstance());
    }

    @Override
    public Optional<ISourceGenerator<BODY>> body() {
        return Optional.ofNullable(this.m_body);
    }

    @Override
    public TYPE withBody(ISourceGenerator<BODY> body) {
        this.m_body = body;
        return (TYPE)((IMethodGenerator)this.thisInstance());
    }

    @Override
    public Stream<IMethodParameterGenerator<?>> parameters() {
        return this.m_parameters.stream();
    }

    @Override
    public TYPE withParameter(IMethodParameterGenerator<?> parameter) {
        if (parameter != null) {
            this.m_parameters.add(parameter);
        }
        return (TYPE)((IMethodGenerator)this.thisInstance());
    }

    @Override
    public TYPE withoutParameter(String parameterName) {
        Ensure.notBlank((CharSequence)parameterName);
        Iterator<IMethodParameterGenerator<?>> it = this.m_parameters.iterator();
        while (it.hasNext()) {
            IMethodParameterGenerator<?> parameter = it.next();
            if (!parameterName.equals(parameter.elementName().orElse(null))) continue;
            it.remove();
            return (TYPE)((IMethodGenerator)this.thisInstance());
        }
        return (TYPE)((IMethodGenerator)this.thisInstance());
    }

    @Override
    public TYPE withTypeParameter(ITypeParameterGenerator<?> typeParameter) {
        if (typeParameter != null) {
            this.m_typeParameters.add(typeParameter);
        }
        return (TYPE)((IMethodGenerator)this.thisInstance());
    }

    @Override
    public Stream<ITypeParameterGenerator<?>> typeParameters() {
        return this.m_typeParameters.stream();
    }

    @Override
    public TYPE withoutTypeParameter(String elementName) {
        Ensure.notNull((Object)elementName);
        this.m_typeParameters.removeIf(generator -> elementName.equals(generator.elementName().orElse(null)));
        return (TYPE)((IMethodGenerator)this.thisInstance());
    }

    @Override
    public TYPE withOverrideIfNecessary() {
        return this.withOverrideIfNecessary(true, null);
    }

    @Override
    public TYPE withoutOverrideIfNecessary() {
        return this.withOverrideIfNecessary(false, null);
    }

    @Override
    public TYPE withOverrideIfNecessary(boolean withOverrideIfNecessary, IType declaringType) {
        this.m_withOverrideIfNecessary = withOverrideIfNecessary;
        this.m_overrideIfNecessaryDeclaringType = withOverrideIfNecessary ? declaringType : null;
        return (TYPE)((IMethodGenerator)this.thisInstance());
    }

    @Override
    public boolean isWithOverrideIfNecessary() {
        return this.m_withOverrideIfNecessary;
    }

    protected IType getOverrideIfNecessaryDeclaringType() {
        return this.m_overrideIfNecessaryDeclaringType;
    }

    @Override
    public TYPE asAbstract() {
        return (TYPE)((IMethodGenerator)this.withFlags(1024));
    }

    @Override
    public TYPE asSynchronized() {
        return (TYPE)((IMethodGenerator)this.withFlags(32));
    }

    @Override
    public TYPE asDefaultMethod() {
        return (TYPE)((IMethodGenerator)this.withFlags(65536));
    }
}

