/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api;

import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataTypeOwner;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;

public interface IConstantValue
extends IDataTypeOwner {
    public <T> Optional<T> convertTo(Class<T> var1);

    public Optional<Path> containingFile();

    default public Optional<String> asString() {
        return this.convertTo(String.class);
    }

    default public Optional<Boolean> asBoolean() {
        return this.convertTo(Boolean.class);
    }

    default public Optional<BigDecimal> asBigDecimal() {
        return this.convertTo(BigDecimal.class);
    }

    default public Optional<IES6Class> asES6Class() {
        return this.convertTo(IES6Class.class);
    }

    default public Optional<IObjectLiteral> asObjectLiteral() {
        return this.convertTo(IObjectLiteral.class);
    }

    default public Optional<IConstantValue[]> asArray() {
        return this.convertTo(IConstantValue[].class);
    }

    default public Optional<?> value() {
        return switch (this.type().ordinal()) {
            case 3 -> this.asString();
            case 1 -> this.asBoolean();
            case 2 -> this.asBigDecimal();
            case 4 -> this.asES6Class();
            case 0 -> this.asObjectLiteral();
            case 5 -> this.asArray();
            default -> Optional.empty();
        };
    }

    public ConstantValueType type();

    public static enum ConstantValueType {
        ObjectLiteral,
        Boolean,
        Numeric,
        String,
        ES6Class,
        Array,
        Unknown;

    }
}

