/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.internal.compiler.parser.IMarkdownCommentHelper;

class MarkdownCommentHelper
implements IMarkdownCommentHelper {
    int commonIndent;
    int slashCount = 0;
    int leadingSpaces = 0;
    int markdownLineStart = -1;
    boolean insideIndentedCodeBlock = false;
    boolean insideFencedCodeBlock = false;
    char fenceChar;
    int fenceCharCount;
    int fenceLength;
    boolean isBlankLine = true;
    boolean previousIsBlankLine = true;
    boolean inInlineCode = false;

    public MarkdownCommentHelper(int lineStart, int commonIndent) {
        this.markdownLineStart = lineStart;
        this.commonIndent = commonIndent;
    }

    @Override
    public void recordSlash(int nextIndex) {
        if (this.slashCount < 3 && ++this.slashCount == 3) {
            this.markdownLineStart = nextIndex;
            this.leadingSpaces = 0;
        }
    }

    @Override
    public void recordFenceChar(char previous, char next, boolean lineStarted) {
        int required;
        if (this.insideIndentedCodeBlock) {
            return;
        }
        if (this.fenceCharCount == 0) {
            if (lineStarted) {
                if (next == '`') {
                    this.inInlineCode ^= true;
                }
                return;
            }
            this.fenceChar = next;
            this.fenceCharCount = 1;
            return;
        }
        if (next != this.fenceChar) {
            return;
        }
        if (previous != next) {
            if (this.insideFencedCodeBlock) {
                this.fenceCharCount = 1;
            }
            return;
        }
        int n = required = this.insideFencedCodeBlock ? this.fenceLength : 3;
        if (++this.fenceCharCount == required) {
            this.insideFencedCodeBlock ^= true;
        }
        if (this.insideFencedCodeBlock && this.fenceCharCount >= this.fenceLength) {
            this.fenceLength = this.fenceCharCount;
        }
    }

    @Override
    public boolean recordSignificantLeadingSpace() {
        if (this.markdownLineStart != -1 && ++this.leadingSpaces > this.commonIndent) {
            if (!this.insideFencedCodeBlock && this.previousIsBlankLine && this.leadingSpaces - this.commonIndent >= 4) {
                this.insideIndentedCodeBlock = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public void recordText() {
        this.isBlankLine = false;
        if (this.leadingSpaces - this.commonIndent < 4) {
            this.insideIndentedCodeBlock = false;
        }
    }

    @Override
    public boolean isInCode() {
        return this.insideIndentedCodeBlock || this.insideFencedCodeBlock || this.inInlineCode;
    }

    @Override
    public int getTextStart(int textStart) {
        if (this.markdownLineStart > -1) {
            return this.markdownLineStart + this.commonIndent;
        }
        return textStart;
    }

    @Override
    public void resetLineStart() {
        this.markdownLineStart = -1;
    }

    @Override
    public void resetAtLineEnd() {
        this.previousIsBlankLine = this.isBlankLine;
        this.isBlankLine = true;
        this.slashCount = 0;
        this.leadingSpaces = 0;
        this.markdownLineStart = -1;
        this.fenceCharCount = 0;
        this.inInlineCode = false;
    }
}

