/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.internal.archive.ArchiveMessages;
import org.eclipse.jst.j2ee.internal.archive.operations.EJBArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.IOverwriteHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.OverwriteHandlerException;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.jee.archive.AbstractArchiveSaveAdapter;
import org.eclipse.jst.jee.archive.ArchiveSaveFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class ComponentArchiveSaveAdapter
extends AbstractArchiveSaveAdapter {
    protected IDataModel dataModel;
    protected IVirtualComponent vComponent;
    protected IOverwriteHandler overwriteHandler;
    protected IProgressMonitor progressMonitor;
    private String archiveComponentsDeployPath;
    private List archiveComponents;
    private Map archiveComponentURIMap;

    public ComponentArchiveSaveAdapter(IVirtualComponent vComponent) {
        if (vComponent == null) {
            throw new NullPointerException();
        }
        this.vComponent = vComponent;
    }

    public void setDataModel(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void setOverwriteHandler(IOverwriteHandler newOverwriteHandler) {
        this.overwriteHandler = newOverwriteHandler;
    }

    public void setProgressMonitor(IProgressMonitor newProgressMonitor) {
        this.progressMonitor = newProgressMonitor;
    }

    protected void validateEdit(IFile aFile) {
        if (this.overwriteHandler == null) {
            return;
        }
        if (!aFile.exists() || !aFile.isReadOnly()) {
            return;
        }
        this.overwriteHandler.validateEdit(aFile);
    }

    protected boolean shouldOverwrite(String uri) {
        if (this.overwriteHandler.isOverwriteNone()) {
            return false;
        }
        return this.overwriteHandler.isOverwriteResources() || this.overwriteHandler.isOverwriteAll() || this.overwriteHandler.shouldOverwrite(uri);
    }

    protected OutputStream getOutputStreamForResource(Resource aResource) throws IOException {
        return null;
    }

    public void save(IProgressMonitor monitor) throws ArchiveSaveFailureException {
        try {
            monitor.beginTask(NLS.bind((String)ArchiveMessages.ComponentArchiveSaveAdapter_Importing_0_, (Object)this.vComponent.getName()), 1010);
            super.save((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            this.linkArchiveComponents();
            monitor.worked(10);
        }
        finally {
            monitor.done();
        }
    }

    public void save(IArchiveResource aFile) throws ArchiveSaveFailureException {
        try {
            try {
                if (this.progressMonitor == null) {
                    this.progressMonitor = new NullProgressMonitor();
                }
                this.progressMonitor.subTask(aFile.getPath().toString());
                InputStream in = aFile.getInputStream();
                IPath projectRelativePath = this.getProjectRelativePath(aFile);
                if (aFile.getType() == 2) {
                    this.saveAsArchiveComponent((IArchive)aFile, projectRelativePath, in);
                } else if (aFile.getType() != 1) {
                    this.saveToOutputPath(projectRelativePath, in);
                } else {
                    this.createDirectory(projectRelativePath);
                }
            }
            catch (OverwriteHandlerException ohe) {
                throw ohe;
            }
            catch (Exception exception) {
                String errorString = String.valueOf(EJBArchiveOpsResourceHandler.ARCHIVE_OPERATION_SaveFile) + aFile.getPath();
                throw new ArchiveSaveFailureException(errorString);
            }
        }
        finally {
            if (this.progressMonitor != null) {
                this.progressMonitor.worked(1);
            }
        }
    }

    protected IPath getProjectRelativePath(IArchiveResource aFile) {
        IPath path = aFile.getPath();
        IFile iFile = null;
        if (path.segmentCount() > 0 && path.segment(0).equals(".settings")) {
            iFile = this.vComponent.getProject().getFile(path);
        } else {
            IVirtualFolder rootFolder = this.vComponent.getRootFolder();
            IVirtualFile vFile = rootFolder.getFile(path);
            iFile = vFile.getUnderlyingFile();
        }
        return iFile.getProjectRelativePath();
    }

    protected void createDirectory(IPath projectRelativePath) throws CoreException {
        IFolder iFolder = this.vComponent.getProject().getFolder(projectRelativePath);
        if (!iFolder.exists()) {
            this.mkdirs(iFolder);
        }
    }

    protected void mkdirs(IFolder folder) throws CoreException {
        IContainer container = folder.getParent();
        if (!container.exists()) {
            this.mkdirs((IFolder)container);
        }
        folder.create(true, true, null);
    }

    protected void saveAsArchiveComponent(IArchive archive, IPath projectRelativePath, InputStream in) throws Exception {
        IFile iFile = this.saveToOutputPath(projectRelativePath, in);
        if (this.shouldLinkAsComponentRef(archive)) {
            IVirtualComponent archiveComponent = ComponentCore.createArchiveComponent((IProject)this.vComponent.getProject(), (String)("lib" + iFile.getFullPath().toString()));
            if (this.archiveComponents == null) {
                this.archiveComponents = new ArrayList();
                this.archiveComponentURIMap = new HashMap();
                this.archiveComponentsDeployPath = String.valueOf('/') + projectRelativePath.removeLastSegments(1).toString();
            }
            this.archiveComponents.add(archiveComponent);
            this.archiveComponentURIMap.put(archiveComponent, iFile.getName());
        }
    }

    protected boolean shouldLinkAsComponentRef(IArchive archive) {
        return false;
    }

    protected void linkArchiveComponents() {
        if (this.archiveComponents != null && this.archiveComponents.size() > 0) {
            IDataModel createReferencesDataModel = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
            createReferencesDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)this.vComponent);
            createReferencesDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)this.archiveComponentsDeployPath);
            createReferencesDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)this.archiveComponents);
            createReferencesDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", (Object)this.archiveComponentURIMap);
            try {
                createReferencesDataModel.getDefaultOperation().execute(null, null);
            }
            catch (ExecutionException e) {
                J2EEPlugin.logError(e);
            }
        }
    }

    protected IFile saveToOutputPath(IPath projectRelativePath, InputStream in) throws Exception {
        IFile iFile = this.vComponent.getProject().getFile(projectRelativePath);
        this.saveToIFile(iFile, in);
        return iFile;
    }

    protected void saveToIFile(IFile iFile, InputStream in) throws Exception {
        this.validateEdit(iFile);
        if (iFile.exists()) {
            iFile.setContents(in, true, true, null);
        } else {
            this.mkdirs(iFile.getFullPath().removeLastSegments(1), ResourcesPlugin.getWorkspace().getRoot());
            iFile.create(in, true, null);
        }
    }

    protected void mkdirs(IPath path, IWorkspaceRoot root) throws CoreException {
        if (path.segmentCount() <= 1) {
            return;
        }
        IFolder folder = root.getFolder(path);
        if (!folder.exists()) {
            this.mkdirs(path.removeLastSegments(1), root);
            folder.create(true, true, null);
        }
    }
}

