/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls;

import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationEntry;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Translation;
import org.eclipse.scout.sdk.core.util.Ensure;

public class TranslationEntry
extends Translation
implements ITranslationEntry {
    private final ITranslationStore m_store;

    public TranslationEntry(ITranslation template, ITranslationStore store) {
        super(template);
        Ensure.notBlank((CharSequence)template.key());
        this.m_store = (ITranslationStore)Ensure.notNull((Object)store);
    }

    public TranslationEntry(String key, ITranslationStore store) {
        super((String)Ensure.notBlank((CharSequence)key));
        this.m_store = (ITranslationStore)Ensure.notNull((Object)store);
    }

    @Override
    public ITranslationStore store() {
        return this.m_store;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.m_store.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TranslationEntry other = (TranslationEntry)obj;
        return this.m_store.equals(other.m_store);
    }

    @Override
    public String toString() {
        return super.toString() + " in " + String.valueOf(this.m_store);
    }
}

