/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.AbstractSegmentStatisticsAnalysis;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreStatisticsDataProvider;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public abstract class AbstractSegmentStoreStatisticsDataProviderFactory
implements IDataProviderFactory {
    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace) {
        return null;
    }

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace, String secondaryId) {
        IAnalysisModule baseAnalysisModule = trace.getAnalysisModule(secondaryId);
        String composedId = this.getDataProviderId() + ":" + secondaryId;
        if (!(baseAnalysisModule instanceof ISegmentStoreProvider)) {
            if (!(trace instanceof TmfExperiment)) {
                return null;
            }
            return TmfTreeCompositeDataProvider.create((Collection)TmfTraceManager.getTraceSet((ITmfTrace)trace), (String)composedId);
        }
        baseAnalysisModule.schedule();
        AbstractSegmentStatisticsAnalysis statisticsAnalysisModule = this.getAnalysis(secondaryId);
        try {
            this.setStatisticsAnalysisModuleName(statisticsAnalysisModule, baseAnalysisModule);
            statisticsAnalysisModule.setTrace(trace);
        }
        catch (TmfAnalysisException e) {
            statisticsAnalysisModule.dispose();
            return null;
        }
        statisticsAnalysisModule.schedule();
        return new SegmentStoreStatisticsDataProvider(trace, statisticsAnalysisModule, composedId);
    }

    public Collection<IDataProviderDescriptor> getDescriptors(ITmfTrace trace) {
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ISegmentStoreProvider.class);
        ArrayList<IDataProviderDescriptor> descriptors = new ArrayList<IDataProviderDescriptor>();
        HashSet<String> existingModules = new HashSet<String>();
        for (ISegmentStoreProvider module : modules) {
            IDataProviderDescriptor descriptor;
            IAnalysisModule analysis = (IAnalysisModule)module;
            if (existingModules.contains(analysis.getId()) || (descriptor = this.getDataProviderDescriptor(analysis)) == null) continue;
            descriptors.add(descriptor);
            existingModules.add(analysis.getId());
        }
        return descriptors;
    }

    protected abstract AbstractSegmentStatisticsAnalysis getAnalysis(String var1);

    protected abstract String getDataProviderId();

    protected abstract void setStatisticsAnalysisModuleName(AbstractSegmentStatisticsAnalysis var1, IAnalysisModule var2);

    protected abstract @Nullable IDataProviderDescriptor getDataProviderDescriptor(IAnalysisModule var1);
}

