/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.ui.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.FilterUpdateEvent;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.search.ui.text.RemoveAllEvent;

public abstract class AbstractTextSearchResult
implements ISearchResult {
    private static final Match[] EMPTY_ARRAY = new Match[0];
    private final ConcurrentMap<Object, Set<Match>> fElementsToMatches = new ConcurrentHashMap<Object, Set<Match>>();
    private final List<ISearchResultListener> fListeners = new ArrayList<ISearchResultListener>();
    private final MatchEvent fMatchEvent = new MatchEvent(this);
    private final AtomicInteger matchCount = new AtomicInteger(0);
    private MatchFilter[] fMatchFilters = null;

    protected AbstractTextSearchResult() {
    }

    public Match[] getMatches(Object element) {
        if (element == null) {
            return EMPTY_ARRAY;
        }
        Set matches = (Set)this.fElementsToMatches.get(element);
        if (matches != null) {
            Match[] sortingCopy = matches.toArray(new Match[matches.size()]);
            Arrays.sort(sortingCopy, AbstractTextSearchResult::compare);
            return sortingCopy;
        }
        return EMPTY_ARRAY;
    }

    public Enumeration<Match> getMatchSet(Object element) {
        if (element == null) {
            return Collections.emptyEnumeration();
        }
        Set matches = (Set)this.fElementsToMatches.get(element);
        if (matches != null) {
            return Collections.enumeration(matches);
        }
        return Collections.emptyEnumeration();
    }

    public void addMatch(Match match) {
        if (this.didAddMatch(match)) {
            this.fireChange(this.getSearchResultEvent(match, 1));
        }
    }

    public void addMatches(Match[] matches) {
        ArrayList<Match> reallyAdded = new ArrayList<Match>();
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            if (this.didAddMatch(match)) {
                reallyAdded.add(match);
            }
            ++n2;
        }
        if (!reallyAdded.isEmpty()) {
            this.fireChange(this.getSearchResultEvent(reallyAdded, 1));
        }
    }

    private MatchEvent getSearchResultEvent(Match match, int eventKind) {
        this.fMatchEvent.setKind(eventKind);
        this.fMatchEvent.setMatch(match);
        return this.fMatchEvent;
    }

    private MatchEvent getSearchResultEvent(Collection<Match> matches, int eventKind) {
        this.fMatchEvent.setKind(eventKind);
        Match[] matchArray = matches.toArray(new Match[matches.size()]);
        this.fMatchEvent.setMatches(matchArray);
        return this.fMatchEvent;
    }

    private boolean didAddMatch(Match match) {
        this.matchCount.set(0);
        this.updateFilterState(match);
        return this.fElementsToMatches.computeIfAbsent(match.getElement(), k -> ConcurrentHashMap.newKeySet()).add(match);
    }

    private static int compare(Match match2, Match match1) {
        int diff = match2.getOffset() - match1.getOffset();
        if (diff != 0) {
            return diff;
        }
        return match2.getLength() - match1.getLength();
    }

    public void removeAll() {
        this.doRemoveAll();
        this.fireChange(new RemoveAllEvent(this));
    }

    private void doRemoveAll() {
        this.matchCount.set(0);
        this.fElementsToMatches.clear();
    }

    public void removeMatch(Match match) {
        if (this.didRemoveMatch(match)) {
            this.fireChange(this.getSearchResultEvent(match, 2));
        }
    }

    public void removeMatches(Match[] matches) {
        ArrayList<Match> existing = new ArrayList<Match>();
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            if (this.didRemoveMatch(match)) {
                existing.add(match);
            }
            ++n2;
        }
        if (!existing.isEmpty()) {
            this.fireChange(this.getSearchResultEvent(existing, 2));
        }
    }

    private boolean didRemoveMatch(Match match) {
        this.matchCount.set(0);
        boolean[] existed = new boolean[1];
        this.fElementsToMatches.computeIfPresent(match.getElement(), (f, matches) -> {
            blArray[0] = matches.remove(match);
            if (matches.isEmpty()) {
                return null;
            }
            return matches;
        });
        return existed[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.fListeners;
        synchronized (list) {
            this.fListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.fListeners;
        synchronized (list) {
            this.fListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChange(SearchResultEvent e) {
        HashSet<ISearchResultListener> copiedListeners = new HashSet<ISearchResultListener>();
        List<ISearchResultListener> list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        Iterator listeners = copiedListeners.iterator();
        while (listeners.hasNext()) {
            ((ISearchResultListener)listeners.next()).searchResultChanged(e);
        }
    }

    private void updateFilterStateForAllMatches() {
        Object[] elements;
        boolean disableFiltering = this.getActiveMatchFilters() == null;
        ArrayList<Match> changed = new ArrayList<Match>();
        Object[] objectArray = elements = this.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Match[] matches;
            Object element = objectArray[n2];
            Match[] matchArray = matches = this.getMatches(element);
            int n3 = matches.length;
            int n4 = 0;
            while (n4 < n3) {
                Match match = matchArray[n4];
                if (disableFiltering || this.updateFilterState(match)) {
                    changed.add(match);
                }
                ++n4;
            }
            ++n2;
        }
        Match[] allChanges = changed.toArray(new Match[changed.size()]);
        this.fireChange(new FilterUpdateEvent(this, allChanges, this.getActiveMatchFilters()));
    }

    private boolean updateFilterState(Match match) {
        MatchFilter[] matchFilters = this.getActiveMatchFilters();
        if (matchFilters == null) {
            return false;
        }
        boolean oldState = match.isFiltered();
        MatchFilter[] matchFilterArray = matchFilters;
        int n = matchFilters.length;
        int n2 = 0;
        while (n2 < n) {
            MatchFilter matchFilter = matchFilterArray[n2];
            if (matchFilter.filters(match)) {
                match.setFiltered(true);
                return !oldState;
            }
            ++n2;
        }
        match.setFiltered(false);
        return oldState;
    }

    public int getMatchCount() {
        int oldCount = this.matchCount.get();
        if (oldCount != 0) {
            return oldCount;
        }
        int newCount = 0;
        for (Set element : this.fElementsToMatches.values()) {
            newCount += element.size();
        }
        if (this.matchCount.compareAndSet(0, newCount)) {
            return newCount;
        }
        return this.getMatchCount();
    }

    public boolean hasMatches() {
        for (Map.Entry entry : this.fElementsToMatches.entrySet()) {
            if (((Set)entry.getValue()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public int getMatchCount(Object element) {
        if (element == null) {
            return 0;
        }
        Set matches = (Set)this.fElementsToMatches.get(element);
        if (matches != null) {
            return matches.size();
        }
        return 0;
    }

    public Object[] getElements() {
        return this.fElementsToMatches.keySet().toArray();
    }

    public int getElementsCount() {
        return this.fElementsToMatches.size();
    }

    public void setActiveMatchFilters(MatchFilter[] filters) {
        this.fMatchFilters = filters;
        this.updateFilterStateForAllMatches();
    }

    public MatchFilter[] getActiveMatchFilters() {
        return this.fMatchFilters;
    }

    public MatchFilter[] getAllMatchFilters() {
        return null;
    }

    public abstract IEditorMatchAdapter getEditorMatchAdapter();

    public abstract IFileMatchAdapter getFileMatchAdapter();
}

