/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FilterHTMLHeadOutputStream
extends FilterOutputStream {
    private static final int STATE_START = 0;
    private static final int STATE_LT = 1;
    private static final int STATE_LT_SLASH = 2;
    private static final int STATE_LT_SLASH_H = 3;
    private static final int STATE_LT_SLASH_HE = 4;
    private static final int STATE_LT_SLASH_HEA = 5;
    private static final int STATE_LT_SLASH_HEAD = 6;
    private static final int STATE_DONE = 7;
    private int state = 0;
    private final byte[] toInsert;
    ByteArrayOutputStream buffer = new ByteArrayOutputStream(7);

    public FilterHTMLHeadOutputStream(OutputStream out, byte[] bytesToInsert) {
        super(out);
        this.toInsert = bytesToInsert;
    }

    @Override
    public final void write(int b) throws IOException {
        switch (this.state) {
            case 0: {
                if (b == 60) {
                    this.buffer.write(b);
                    this.state = 1;
                    break;
                }
                this.out.write(b);
                break;
            }
            case 1: {
                this.buffer.write(b);
                if (b == 47) {
                    this.state = 2;
                    break;
                }
                this.reset();
                break;
            }
            case 2: {
                this.buffer.write(b);
                if (b == 104 || b == 72) {
                    this.state = 3;
                    break;
                }
                this.reset();
                break;
            }
            case 3: {
                this.buffer.write(b);
                if (b == 101 || b == 69) {
                    this.state = 4;
                    break;
                }
                this.reset();
                break;
            }
            case 4: {
                this.buffer.write(b);
                if (b == 97 || b == 65) {
                    this.state = 5;
                    break;
                }
                this.reset();
                break;
            }
            case 5: {
                this.buffer.write(b);
                if (b == 100 || b == 68) {
                    this.state = 6;
                    break;
                }
                this.reset();
                break;
            }
            case 6: {
                this.buffer.write(b);
                if (b == 62) {
                    this.out.write(this.toInsert);
                    this.out.write(10);
                    this.reset();
                    this.state = 7;
                    break;
                }
                this.reset();
                break;
            }
            default: {
                this.out.write(b);
            }
        }
    }

    private void reset() throws IOException {
        this.out.write(this.buffer.toByteArray());
        this.buffer.reset();
        this.state = 0;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.state == 7) {
            this.out.write(b, off, len);
        } else {
            int i = 0;
            while (i < len) {
                this.write(b[off + i]);
                ++i;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.reset();
        super.close();
    }
}

