/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;

public abstract class CuCollectingSearchRequestor
extends CollectingSearchRequestor {
    private IJavaScriptUnit fCuCache;
    private IScanner fScannerCache;

    protected IScanner getScanner(IJavaScriptUnit unit) {
        if (unit.equals(this.fCuCache)) {
            return this.fScannerCache;
        }
        this.fCuCache = unit;
        IJavaScriptProject project = unit.getJavaScriptProject();
        String sourceLevel = project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        String complianceLevel = project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
        this.fScannerCache = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)sourceLevel, (String)complianceLevel);
        return this.fScannerCache;
    }

    @Override
    public final void acceptSearchMatch(SearchMatch match) throws CoreException {
        IJavaScriptUnit unit = SearchUtils.getCompilationUnit(match);
        if (unit == null) {
            return;
        }
        this.acceptSearchMatch(unit, match);
    }

    public void collectMatch(SearchMatch match) throws CoreException {
        super.acceptSearchMatch(match);
    }

    protected abstract void acceptSearchMatch(IJavaScriptUnit var1, SearchMatch var2) throws CoreException;

    public void endReporting() {
        this.fCuCache = null;
        this.fScannerCache = null;
    }
}

