/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNameBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPTemplateParameterOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPTwoPhaseBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public abstract class CPPTemplateParameter
extends PlatformObject
implements ICPPTemplateParameter,
ICPPInternalBinding,
ICPPTwoPhaseBinding,
ICPPUnknownBinding {
    private IASTName[] declarations;
    private final int fParameterID;

    public CPPTemplateParameter(IASTName name) {
        this.declarations = new IASTName[]{name};
        this.fParameterID = this.computeParameterID(name);
    }

    private int computeParameterID(IASTName name) {
        int nesting = 0;
        ICPPASTTemplateParameter tp = null;
        ICPPASTTemplateParameter[] tps = null;
        IASTNode node = name.getParent();
        while (node != null) {
            if (tp == null && node instanceof ICPPASTTemplateParameter) {
                tp = (ICPPASTTemplateParameter)node;
            } else {
                if (node instanceof ICPPASTInternalTemplateDeclaration) {
                    ICPPASTInternalTemplateDeclaration tdecl = (ICPPASTInternalTemplateDeclaration)node;
                    nesting += tdecl.getNestingLevel();
                    if (tps != null) break;
                    tps = tdecl.getTemplateParameters();
                    break;
                }
                if (node instanceof ICPPASTTemplatedTypeTemplateParameter) {
                    ++nesting;
                    if (tps == null) {
                        tps = ((ICPPASTTemplatedTypeTemplateParameter)node).getTemplateParameters();
                    }
                }
            }
            node = node.getParent();
        }
        int pos = 0;
        if (tps != null && tp != null) {
            int i = 0;
            while (i < tps.length) {
                if (tps[i] == tp) {
                    pos = i;
                    break;
                }
                ++i;
            }
        }
        return (nesting << 16) + (pos & 0xFFFF);
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return t;
    }

    @Override
    public final String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public final char[] getNameCharArray() {
        IASTName[] iASTNameArray = this.declarations;
        int n = this.declarations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName decl = iASTNameArray[n2];
            if (decl == null) break;
            char[] result = decl.getSimpleID();
            if (result.length > 0) {
                return result;
            }
            ++n2;
        }
        return CharArrayUtils.EMPTY;
    }

    @Override
    public int getParameterID() {
        return this.fParameterID;
    }

    @Override
    public short getParameterPosition() {
        return (short)this.fParameterID;
    }

    @Override
    public short getTemplateNestingLevel() {
        return (short)(this.fParameterID >> 16);
    }

    public IASTName getPrimaryDeclaration() {
        return this.declarations[0];
    }

    private ICPPASTTemplateParameter getASTTemplateParameter() {
        IASTNode node = this.declarations[0];
        while (node != null && !(node instanceof ICPPASTTemplateParameter)) {
            node = node.getParent();
        }
        assert (node != null);
        return (ICPPASTTemplateParameter)node;
    }

    @Override
    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.getPrimaryDeclaration());
    }

    @Override
    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return new char[][]{this.getNameCharArray()};
    }

    @Override
    public boolean isGloballyQualified() {
        return false;
    }

    public IASTName[] getDeclarations() {
        return this.declarations;
    }

    @Override
    public IASTNode getDefinition() {
        if (this.declarations != null && this.declarations.length > 0) {
            return this.declarations[0];
        }
        return null;
    }

    @Override
    public void addDefinition(IASTNode node) {
        this.addDeclaration(node);
    }

    @Override
    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName name = (IASTName)node;
        if (this.declarations == null) {
            this.declarations = new IASTName[]{name};
        } else {
            if (this.declarations.length > 0 && this.declarations[0] == node) {
                return;
            }
            this.declarations = this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset() ? ArrayUtil.prepend(IASTName.class, this.declarations, name) : ArrayUtil.append(IASTName.class, this.declarations, name);
        }
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public IBinding getOwner() {
        if (this.declarations == null || this.declarations.length == 0) {
            return null;
        }
        IASTNode node = this.declarations[0];
        while (!(node instanceof ICPPASTTemplateParameter)) {
            if (node == null) {
                return null;
            }
            node = node.getParent();
        }
        return CPPTemplates.getContainingTemplate((ICPPASTTemplateParameter)node);
    }

    @Override
    public IBinding resolveFinalBinding(CPPASTNameBase name) {
        IBinding current = name.getPreBinding();
        if (current != this) {
            return current;
        }
        ICPPTemplateDefinition template = CPPTemplates.getContainingTemplate(this.getASTTemplateParameter());
        if (template instanceof ICPPTemplateParameterOwner) {
            return ((ICPPTemplateParameterOwner)((Object)template)).resolveTemplateParameter(this);
        }
        if (template == null) {
            return this;
        }
        ICPPTemplateParameter[] params = template.getTemplateParameters();
        short pos = this.getParameterPosition();
        if (pos < params.length) {
            return params[pos];
        }
        return new ProblemBinding(this.getPrimaryDeclaration(), 7);
    }
}

