/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.eclipse.tracecompass.tmf.core.model.ISampling;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;

public class SeriesModelSerializer
extends StdSerializer<ISeriesModel> {
    private static final long serialVersionUID = -4359431726167157401L;

    public SeriesModelSerializer() {
        super(ISeriesModel.class);
    }

    public void serialize(ISeriesModel value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField("seriesId", value.getId());
        gen.writeStringField("seriesName", value.getName());
        ISampling sampling = value.getSampling();
        if (sampling instanceof ISampling.Timestamps) {
            ISampling.Timestamps timestamps = (ISampling.Timestamps)sampling;
            gen.writeObjectField("xValues", (Object)timestamps.timestamps());
        } else if (sampling instanceof ISampling.Categories) {
            ISampling.Categories categories = (ISampling.Categories)sampling;
            gen.writeObjectField("xCategories", (Object)categories.categories());
        } else if (sampling instanceof ISampling.Ranges) {
            ISampling.Ranges timeRanges = (ISampling.Ranges)sampling;
            gen.writeFieldName("xRanges");
            gen.writeStartArray();
            for (ISampling.Range range : timeRanges.ranges()) {
                gen.writeStartObject();
                gen.writeNumberField("start", ((Long)range.start()).longValue());
                gen.writeNumberField("end", ((Long)range.end()).longValue());
                gen.writeEndObject();
            }
            gen.writeEndArray();
        } else {
            throw new IllegalArgumentException("Unknown Sampling type: " + value.getClass().getName());
        }
        gen.writeObjectField("yValues", (Object)value.getData());
        String type = value.getDisplayType().name().toLowerCase().trim();
        OutputElementStyle style = new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"series-type", (Object)type));
        gen.writeObjectField("style", (Object)style);
        gen.writeObjectField("xValuesDescription", (Object)value.getXAxisDescription());
        gen.writeObjectField("yValuesDescription", (Object)value.getYAxisDescription());
        gen.writeEndObject();
    }
}

