/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import java.util.EventObject;
import org.eclipse.cdt.core.resources.IPathEntryVariableManager;
import org.eclipse.core.runtime.IPath;

public class PathEntryVariableChangeEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    public static final int VARIABLE_CHANGED = 1;
    public static final int VARIABLE_CREATED = 2;
    public static final int VARIABLE_DELETED = 3;
    private String variableName;
    private IPath value;
    private int type;

    public PathEntryVariableChangeEvent(IPathEntryVariableManager source, String variableName, IPath value, int type) {
        super(source);
        if (type < 1 || type > 3) {
            throw new IllegalArgumentException("Invalid event type: " + type);
        }
        this.variableName = variableName;
        this.value = value;
        this.type = type;
    }

    public IPath getValue() {
        return this.value;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public String toString() {
        String[] typeStrings = new String[]{"VARIABLE_CHANGED", "VARIABLE_CREATED", "VARIABLE_DELETED"};
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("[variable = ");
        sb.append(this.variableName);
        sb.append(", type = ");
        sb.append(typeStrings[this.type - 1]);
        if (this.type != 3) {
            sb.append(", value = ");
            sb.append(this.value);
        }
        sb.append("]");
        return sb.toString();
    }
}

