/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.pty;

import java.io.IOException;
import org.eclipse.cdt.internal.core.natives.CNativePlugin;
import org.eclipse.cdt.internal.core.natives.Messages;
import org.eclipse.cdt.utils.pty.ConPTY;
import org.eclipse.cdt.utils.pty.ConPTYInputStream;
import org.eclipse.cdt.utils.pty.ConPTYOutputStream;
import org.eclipse.cdt.utils.pty.PTYInputStream;
import org.eclipse.cdt.utils.pty.PTYOutputStream;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.runtime.Platform;

public class PTY {
    private static final String CONPTY_ENABLED_PROP = "org.eclipse.cdt.core.conpty_enabled";
    private static final String FORCE_CONSOLE_MODE_ENABLED_PROP = "org.eclipse.cdt.core.winpty_console_mode";
    final Mode mode;
    final String slave;
    final PTYInputStream in;
    final PTYOutputStream out;
    int master;
    private static PTY_TYPE ptyType = PTY_TYPE.PTY_UNKNOWN;
    private static boolean isConsoleModeSupported;
    private static boolean setTerminalSizeErrorAlreadyLogged;
    private ConPTY conPTY;

    static {
        if ("win32".equals(Platform.getOS())) {
            boolean conPtyEnabled = Boolean.parseBoolean(System.getProperty(CONPTY_ENABLED_PROP, "true"));
            if (conPtyEnabled) {
                try {
                    ConPTY pty = new ConPTY();
                    pty.close();
                    ptyType = PTY_TYPE.PTY_CONPTY;
                    isConsoleModeSupported = Boolean.getBoolean(FORCE_CONSOLE_MODE_ENABLED_PROP);
                }
                catch (NoClassDefFoundError e) {
                    CNativePlugin.log(Messages.PTY_NoClassDefFoundError, e);
                }
                catch (Throwable e) {
                    CNativePlugin.log(Messages.PTY_FailedToStartConPTY, e);
                }
            }
            if (ptyType == PTY_TYPE.PTY_UNKNOWN) {
                try {
                    System.loadLibrary("winpty");
                    System.loadLibrary("pty");
                    ptyType = PTY_TYPE.PTY_WINPTY;
                    isConsoleModeSupported = Boolean.getBoolean(FORCE_CONSOLE_MODE_ENABLED_PROP);
                }
                catch (Throwable e) {
                    CNativePlugin.log(Messages.PTY_FailedToStartWinPTY, e);
                }
            }
        } else {
            try {
                System.loadLibrary("pty");
                ptyType = PTY_TYPE.PTY_NATIVE;
                isConsoleModeSupported = true;
            }
            catch (Throwable e) {
                CNativePlugin.log(Messages.PTY_FailedToStartNativePTY, e);
            }
        }
        if (ptyType == PTY_TYPE.PTY_UNKNOWN) {
            ptyType = PTY_TYPE.PTY_BROKEN;
            isConsoleModeSupported = true;
            CNativePlugin.log(Messages.PTY_FailedToStartPTY);
        }
    }

    @Deprecated
    public static boolean isSupported() {
        return PTY.isSupported(Mode.CONSOLE);
    }

    public static boolean isSupported(Mode mode) {
        return ptyType != PTY_TYPE.PTY_BROKEN && (isConsoleModeSupported || mode == Mode.TERMINAL);
    }

    public PTY() throws IOException {
        this(Mode.CONSOLE);
    }

    public PTY(Mode mode) throws IOException {
        this.mode = mode;
        if (this.isConsole() && !isConsoleModeSupported) {
            throw new IOException(Messages.Util_exception_cannotCreatePty);
        }
        PTYInputStream inInit = null;
        PTYOutputStream outInit = null;
        String slaveInit = null;
        if (ptyType == PTY_TYPE.PTY_CONPTY) {
            this.conPTY = new ConPTY();
            slaveInit = "conpty";
            inInit = new ConPTYInputStream(this.conPTY);
            outInit = new ConPTYOutputStream(this.conPTY);
        } else {
            String string = slaveInit = ptyType != PTY_TYPE.PTY_BROKEN ? this.openMaster(this.isConsole()) : null;
            if (slaveInit == null) {
                throw new IOException(Messages.Util_exception_cannotCreatePty);
            }
            inInit = new PTYInputStream(new MasterFD());
            outInit = new PTYOutputStream(new MasterFD(), ptyType != PTY_TYPE.PTY_WINPTY);
        }
        this.slave = slaveInit;
        this.in = inInit;
        this.out = outInit;
    }

    public void validateSlaveName() throws IOException {
        if (ptyType == PTY_TYPE.PTY_CONPTY || ptyType == PTY_TYPE.PTY_WINPTY) {
            throw new IOException("Slave name is not valid");
        }
    }

    public String getSlaveName() {
        return this.slave;
    }

    public MasterFD getMasterFD() {
        return new MasterFD();
    }

    public final boolean isConsole() {
        return this.mode == Mode.CONSOLE;
    }

    public PTYOutputStream getOutputStream() {
        return this.out;
    }

    public PTYInputStream getInputStream() {
        return this.in;
    }

    public final void setTerminalSize(int width, int height) {
        block4: {
            try {
                if (ptyType == PTY_TYPE.PTY_CONPTY) {
                    this.conPTY.setTerminalSize(width, height);
                } else {
                    this.change_window_size(this.master, width, height);
                }
            }
            catch (IOException | UnsatisfiedLinkError e) {
                if (setTerminalSizeErrorAlreadyLogged) break block4;
                setTerminalSizeErrorAlreadyLogged = true;
                CNativePlugin.log(Messages.Util_exception_cannotSetTerminalSize, e);
            }
        }
    }

    public int exec_pty(Spawner spawner, String[] cmdarray, String[] envp, String dir, Spawner.IChannel[] chan) throws IOException {
        if (ptyType == PTY_TYPE.PTY_CONPTY) {
            return this.conPTY.exec(cmdarray, envp, dir);
        }
        if (ptyType == PTY_TYPE.PTY_WINPTY) {
            return this.exec2(cmdarray, envp, dir, chan, this.slave, this.master, this.isConsole());
        }
        return spawner.exec2(cmdarray, envp, dir, chan, this.slave, this.master, this.isConsole());
    }

    public int waitFor(Spawner spawner, int pid) {
        if (ptyType == PTY_TYPE.PTY_CONPTY) {
            return this.conPTY.waitFor();
        }
        if (ptyType == PTY_TYPE.PTY_WINPTY) {
            return this.waitFor(this.master, pid);
        }
        return spawner.waitFor(pid);
    }

    native String openMaster(boolean var1);

    native int change_window_size(int var1, int var2, int var3);

    native int exec2(String[] var1, String[] var2, String var3, Spawner.IChannel[] var4, String var5, int var6, boolean var7) throws IOException;

    native int waitFor(int var1, int var2);

    public class MasterFD {
        public int getFD() {
            return PTY.this.master;
        }

        void setFD(int fd) {
            PTY.this.master = fd;
        }
    }

    public static enum Mode {
        CONSOLE,
        TERMINAL;

    }

    private static enum PTY_TYPE {
        PTY_UNKNOWN,
        PTY_CONPTY,
        PTY_WINPTY,
        PTY_NATIVE,
        PTY_BROKEN;

    }
}

