/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceEventFormat;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceEventSystem;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFileCPU;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFileType;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFormatField;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFunctionAddressNameMapping;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceHeaderEvent;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceHeaderInfo;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceOption;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceVersionHeader;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser.AbstractBinaryFTraceFileParser;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser.BinaryFTraceByteBuffer;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser.BinaryFTraceFileMapping;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser.BinaryFTraceHeaderElementSize;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;

public class BinaryFTraceFileParser
extends AbstractBinaryFTraceFileParser {
    private static final String UNSECURE_TRACE_ERROR_MESSAGE = "Buffer overrun stopped";

    private BinaryFTraceFileParser() {
    }

    private static void validate(BinaryFTraceByteBuffer buffer, long bytesToRead) throws TmfTraceException {
        if (buffer.getCurrentOffset() + bytesToRead > buffer.getFileSize()) {
            throw new TmfTraceException(BinaryFTraceFileParser.getUnsecureFileErrorMessage(buffer.getCurrentOffset(), buffer.getFileSize(), bytesToRead));
        }
    }

    public static BinaryFTraceVersionHeader getFtraceVersionHeader(String path) throws TmfTraceException {
        try {
            BinaryFTraceByteBuffer buffer = new BinaryFTraceByteBuffer(path);
            return BinaryFTraceFileParser.getFtraceVersionHeader(buffer);
        }
        catch (IOException e) {
            throw new TmfTraceException("Cannot open trace file", (Throwable)e);
        }
    }

    private static BinaryFTraceVersionHeader getFtraceVersionHeader(BinaryFTraceByteBuffer buffer) throws TmfTraceException {
        BinaryFTraceFileParser.validate(buffer, BinaryFTraceHeaderElementSize.getMagicValueSectionSize());
        byte[] bytes = buffer.getNextBytes(10);
        String strVersion = buffer.getNextString().trim();
        return BinaryFTraceFileParser.getMagicValuesAndFtraceVersion(bytes, strVersion);
    }

    public static BinaryFTraceHeaderInfo parse(String path) throws TmfTraceException {
        try {
            BinaryFTraceHeaderInfo.BinaryFTraceHeaderInfoBuilder builder = new BinaryFTraceHeaderInfo.BinaryFTraceHeaderInfoBuilder();
            builder.filePath(path);
            BinaryFTraceFileMapping traceMapping = new BinaryFTraceFileMapping(path);
            BinaryFTraceByteBuffer buffer = new BinaryFTraceByteBuffer(traceMapping);
            BinaryFTraceVersionHeader versionHeader = BinaryFTraceFileParser.getFtraceVersionHeader(buffer);
            builder.version(versionHeader.getFTraceVersion());
            ByteOrder endianess = BinaryFTraceFileParser.getFileEndianess(buffer);
            builder.endianess(endianess);
            traceMapping.order(endianess);
            builder.longValueSize(BinaryFTraceFileParser.getLongValueSize(buffer));
            int pageSize = BinaryFTraceFileParser.getHostPageSize(buffer);
            builder.hostMachinePageSize(pageSize);
            builder.headerPageFields(BinaryFTraceFileParser.parseHeaderPage(buffer));
            builder.headerEventInfo(BinaryFTraceFileParser.parseHeaderEvent(buffer));
            builder.fTraceEventFormats(BinaryFTraceFileParser.parseTraceEventsFormat(buffer));
            builder.eventSystems(BinaryFTraceFileParser.parseEventSystemsAndFormats(buffer));
            builder.functionMapping(BinaryFTraceFileParser.parseFunctionMapping(buffer));
            builder.printKPointerStringMapping(BinaryFTraceFileParser.parseTracePrintKInfo(buffer));
            builder.processIDNameMapping(BinaryFTraceFileParser.parseProcessToFunctionNameMapping(buffer));
            int cpuCount = BinaryFTraceFileParser.parseCPUCount(buffer);
            String sectionType = buffer.getNextBytesAsString(10L).trim();
            if (sectionType.equals("options")) {
                builder.options(BinaryFTraceFileParser.parseOptionsSection(buffer));
                sectionType = buffer.getNextBytesAsString(10L).trim();
            }
            if (sectionType.equals("latency")) {
                builder.fileType(BinaryFTraceFileType.LATENCY);
            } else if (sectionType.equals("flyrecord")) {
                builder.fileType(BinaryFTraceFileType.FLY_RECORD);
                builder.cpus(BinaryFTraceFileParser.parseFlyRecordSection(buffer, cpuCount, pageSize));
            }
            return builder.build(traceMapping);
        }
        catch (IOException ex) {
            throw new TmfTraceException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static List<BinaryFTraceFormatField> parseHeaderPage(BinaryFTraceByteBuffer buffer) throws TmfTraceException {
        BinaryFTraceFileParser.validate(buffer, BinaryFTraceHeaderElementSize.getHeaderPageSectionHeaderSize());
        buffer.getNextBytesAsString(12L);
        long headerPageSize = buffer.getNextLong();
        BinaryFTraceFileParser.validate(buffer, headerPageSize);
        String headerPageContent = buffer.getNextBytesAsString(headerPageSize);
        return BinaryFTraceFileParser.extractHeaderPageContent(headerPageContent);
    }

    private static BinaryFTraceHeaderEvent parseHeaderEvent(BinaryFTraceByteBuffer buffer) throws TmfTraceException {
        BinaryFTraceFileParser.validate(buffer, BinaryFTraceHeaderElementSize.getHeaderEventSectionHeaderSize());
        buffer.getNextBytesAsString(13L);
        long headerEventSize = buffer.getNextLong();
        BinaryFTraceFileParser.validate(buffer, headerEventSize);
        String strHeaderEventInfo = buffer.getNextBytesAsString(headerEventSize);
        return BinaryFTraceFileParser.extractHeaderEventContent(strHeaderEventInfo);
    }

    private static Map<Integer, BinaryFTraceEventFormat> parseTraceEventsFormat(BinaryFTraceByteBuffer buffer) throws TmfTraceException {
        ArrayList<String> eventFormats = new ArrayList<String>();
        BinaryFTraceFileParser.validate(buffer, 4L);
        int numOfTraceEventFormats = buffer.getNextInt();
        int i = 0;
        while (i < numOfTraceEventFormats) {
            BinaryFTraceFileParser.validate(buffer, 8L);
            long formatSize = buffer.getNextLong();
            BinaryFTraceFileParser.validate(buffer, formatSize);
            eventFormats.add(buffer.getNextBytesAsString(formatSize));
            ++i;
        }
        return BinaryFTraceFileParser.extractTraceEventsFormat(eventFormats);
    }

    private static List<BinaryFTraceEventSystem> parseEventSystemsAndFormats(BinaryFTraceByteBuffer buffer) throws TmfTraceException {
        HashMap<String, List<String>> eventSystemData = new HashMap<String, List<String>>();
        BinaryFTraceFileParser.validate(buffer, 4L);
        int numOfEventSystems = buffer.getNextInt();
        int i = 0;
        while (i < numOfEventSystems) {
            String eventSystemName = buffer.getNextString();
            BinaryFTraceFileParser.validate(buffer, 4L);
            int numOfEvents = buffer.getNextInt();
            ArrayList<String> lstEventFormat = new ArrayList<String>();
            int j = 0;
            while (j < numOfEvents) {
                BinaryFTraceFileParser.validate(buffer, 8L);
                long eventSize = buffer.getNextLong();
                BinaryFTraceFileParser.validate(buffer, eventSize);
                lstEventFormat.add(buffer.getNextBytesAsString(eventSize));
                ++j;
            }
            eventSystemData.put(eventSystemName, lstEventFormat);
            ++i;
        }
        return BinaryFTraceFileParser.extractEventSystemsAndFormats(eventSystemData);
    }

    private static Map<String, BinaryFTraceFunctionAddressNameMapping> parseFunctionMapping(BinaryFTraceByteBuffer buffer) throws TmfTraceException {
        BinaryFTraceFileParser.validate(buffer, 4L);
        int dataSize = buffer.getNextInt();
        BinaryFTraceFileParser.validate(buffer, dataSize);
        String strMappings = buffer.getNextBytesAsString(dataSize);
        return BinaryFTraceFileParser.extractFunctionMappingContent(strMappings);
    }

    private static Map<String, String> parseTracePrintKInfo(BinaryFTraceByteBuffer buffer) throws TmfTraceException {
        BinaryFTraceFileParser.validate(buffer, 4L);
        int dataSize = buffer.getNextInt();
        BinaryFTraceFileParser.validate(buffer, dataSize);
        String strMappings = buffer.getNextBytesAsString(dataSize);
        return BinaryFTraceFileParser.extractPrintKContent(strMappings);
    }

    private static Map<Integer, String> parseProcessToFunctionNameMapping(BinaryFTraceByteBuffer buffer) throws TmfTraceException {
        BinaryFTraceFileParser.validate(buffer, 8L);
        long dataSize = buffer.getNextLong();
        BinaryFTraceFileParser.validate(buffer, dataSize);
        String strMappings = buffer.getNextBytesAsString(dataSize);
        return BinaryFTraceFileParser.extractFunctionNameMapping(strMappings);
    }

    private static List<BinaryFTraceFileCPU> parseFlyRecordSection(BinaryFTraceByteBuffer buffer, int cpuCount, int pageSize) throws TmfTraceException {
        BinaryFTraceFileParser.validate(buffer, (long)cpuCount * 16L);
        long totalTraceSize = 0L;
        long[] cpuSectionStartingOffset = new long[cpuCount];
        long[] cpuSectionSize = new long[cpuCount];
        int i = 0;
        while (i < cpuCount) {
            cpuSectionStartingOffset[i] = buffer.getNextLong();
            cpuSectionSize[i] = buffer.getNextLong();
            totalTraceSize += cpuSectionSize[i];
            if (cpuSectionStartingOffset[i] + cpuSectionSize[i] > buffer.getFileSize()) {
                String errorMessage = BinaryFTraceFileParser.getUnsecureFileErrorMessage(cpuSectionStartingOffset[i], buffer.getCurrentOffset(), cpuSectionSize[i]);
                throw new TmfTraceException(errorMessage);
            }
            ++i;
        }
        if (totalTraceSize == 0L) {
            throw new TmfTraceException("Empty trace.");
        }
        return BinaryFTraceFileParser.parseCPUPageHeader(buffer, cpuSectionStartingOffset, cpuSectionSize, pageSize);
    }

    private static List<BinaryFTraceFileCPU> parseCPUPageHeader(BinaryFTraceByteBuffer buffer, long[] cpuSectionStartingOffset, long[] cpuSectionSize, int pageSize) throws TmfTraceException {
        HashMap<Integer, List<Long>> mapTimeStamp = new HashMap<Integer, List<Long>>();
        HashMap<Integer, List<Long>> mapFlag = new HashMap<Integer, List<Long>>();
        HashMap mapStartingOffset = new HashMap();
        int cpuCount = cpuSectionStartingOffset.length;
        int cpuNumber = 0;
        while (cpuNumber < cpuCount) {
            long sectionStartingOffset;
            ArrayList<Long> lstTimeStamp = new ArrayList<Long>();
            ArrayList<Long> lstFlag = new ArrayList<Long>();
            ArrayList<Long> lstStartingOffset = new ArrayList<Long>();
            long pageStartingOffset = sectionStartingOffset = cpuSectionStartingOffset[cpuNumber];
            long endingOffset = sectionStartingOffset + cpuSectionSize[cpuNumber];
            while (pageStartingOffset < endingOffset) {
                buffer.movePointerToOffset(pageStartingOffset);
                BinaryFTraceFileParser.validate(buffer, 16L);
                lstTimeStamp.add(buffer.getNextLong());
                lstFlag.add(buffer.getNextLong());
                lstStartingOffset.add(pageStartingOffset);
                pageStartingOffset += (long)pageSize;
            }
            mapTimeStamp.put(cpuNumber, lstTimeStamp);
            mapFlag.put(cpuNumber, lstFlag);
            mapStartingOffset.put(cpuNumber, lstStartingOffset);
            ++cpuNumber;
        }
        return BinaryFTraceFileParser.initializeCPUs(mapTimeStamp, mapFlag, cpuSectionStartingOffset, cpuSectionSize, pageSize);
    }

    private static List<BinaryFTraceOption> parseOptionsSection(BinaryFTraceByteBuffer buffer) throws TmfTraceException {
        ArrayList<Short> optionTypes = new ArrayList<Short>();
        ArrayList<String> optionData = new ArrayList<String>();
        short optionType = 0;
        int optionSize = 0;
        do {
            BinaryFTraceFileParser.validate(buffer, 2L);
            optionType = buffer.getNextShort();
            if (optionType <= 0) continue;
            BinaryFTraceFileParser.validate(buffer, 4L);
            optionSize = buffer.getNextInt();
            optionTypes.add(optionType);
            optionData.add(buffer.getNextBytesAsString(optionSize).trim());
        } while (optionType > 0);
        return BinaryFTraceFileParser.extractOptionsSection(optionTypes, optionData);
    }

    private static int parseCPUCount(BinaryFTraceByteBuffer buffer) throws TmfTraceException {
        BinaryFTraceFileParser.validate(buffer, 4L);
        return buffer.getNextInt();
    }

    private static String getUnsecureFileErrorMessage(long offset, long fileSize, long bytesToRead) {
        String errorMessage = "Buffer overrun stopped. Requested %d from %d, but file is %d bytes long.";
        return String.format(errorMessage, bytesToRead, offset, fileSize);
    }
}

