/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.IHistoryTree;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.ParentNode;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

class HistoryTreeBackendIterator
implements Iterator<ITmfStateInterval> {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(HistoryTreeBackendIterator.class);
    private final @NonNull IHistoryTree fSht;
    private final IntegerRangeCondition fQuarks;
    private final TimeRangeCondition fTimes;
    private final boolean fReverse;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull TraceCompassLogUtils.FlowScopeLog fParentLog;
    private final Deque<Integer> fSeqNumberQueue;
    private Iterator<@NonNull HTInterval> intervalQueue = Collections.emptyIterator();

    HistoryTreeBackendIterator(@NonNull IHistoryTree sht, IntegerRangeCondition quarks, TimeRangeCondition times, boolean reverse, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull TraceCompassLogUtils.FlowScopeLog parentLog) {
        this.fSht = sht;
        this.fQuarks = quarks;
        this.fTimes = times;
        this.fReverse = reverse;
        this.fParentLog = parentLog;
        this.fSeqNumberQueue = new ArrayDeque<Integer>(Collections.singleton(this.fSht.getRootNode().getSequenceNumber()));
    }

    @Override
    public boolean hasNext() {
        Throwable throwable;
        while (!this.intervalQueue.hasNext() && !this.fSeqNumberQueue.isEmpty()) {
            Object currentNode;
            try {
                TimeRangeCondition subTimes;
                currentNode = this.fSht.readNode(this.fSeqNumberQueue);
                TimeRangeCondition timeRangeCondition = subTimes = ((HTNode)currentNode).getParentSequenceNumber() == -1 ? this.fTimes : this.fTimes.subCondition(((HTNode)currentNode).getNodeStart(), ((HTNode)currentNode).getNodeEnd());
                if (!this.fQuarks.intersects(((HTNode)currentNode).getMinQuark(), ((HTNode)currentNode).getMaxQuark()) || subTimes == null) continue;
                if (((HTNode)currentNode).getNodeType() == HTNode.NodeType.CORE) {
                    ((ParentNode)currentNode).queueNextChildren2D(this.fQuarks, subTimes, this.fSeqNumberQueue, this.fReverse);
                }
                this.intervalQueue = ((HTNode)currentNode).iterable2D(this.fQuarks, subTimes).iterator();
            }
            catch (ClosedChannelException closedChannelException) {
                currentNode = null;
                throwable = null;
                try {
                    TraceCompassLogUtils.FlowScopeLog closedChannelLog = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINER, "HistoryTreeBackendIterator:query2D:channelClosed", new Object[0]).setParentScope(this.fParentLog).build();
                    if (closedChannelLog != null) {
                        closedChannelLog.close();
                    }
                    return false;
                }
                catch (Throwable throwable2) {
                    if (currentNode == null) {
                        currentNode = throwable2;
                    } else if (currentNode != throwable2) {
                        ((Throwable)currentNode).addSuppressed(throwable2);
                    }
                    throw currentNode;
                }
            }
        }
        boolean hasNext = this.intervalQueue.hasNext();
        if (!hasNext) {
            throwable = null;
            Object var3_6 = null;
            try {
                TraceCompassLogUtils.FlowScopeLog noNext = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINER, "HistoryTreeBackendIterator:query2D:iteratorEnd", new Object[0]).setParentScope(this.fParentLog).build();
                if (noNext != null) {
                    noNext.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        return this.intervalQueue.hasNext();
    }

    @Override
    public ITmfStateInterval next() {
        return this.intervalQueue.next();
    }
}

