/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.event.matching;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.datastore.core.serialization.SafeByteBufferFactory;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.INamedSegment;
import org.eclipse.tracecompass.tmf.core.event.matching.IEventMatchingKey;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventDependency;

public class EventMatchingLatency
implements INamedSegment {
    public static final IHTIntervalReader<ISegment> MATCHING_LATENCY_READ_FACTORY = buffer -> new EventMatchingLatency(buffer.getLong(), buffer.getLong(), buffer.get() >= 0, buffer.getString());
    private static final String DEFAULT_TYPE = "";
    private static final String TRACE_SEPARATOR = ", ";
    private final long fStart;
    private final long fEnd;
    private final boolean fReverse;
    private final String fType;
    private static final long serialVersionUID = 5048079637591761143L;

    public EventMatchingLatency(long start, long end, boolean reverse, String type) {
        this.fStart = start;
        this.fEnd = end;
        this.fReverse = reverse;
        this.fType = type;
    }

    public EventMatchingLatency(@Nullable IEventMatchingKey eventKey, TmfEventDependency match) {
        long start = match.getSource().getTimestamp().toNanos();
        long end = match.getDestination().getTimestamp().toNanos();
        if (start <= end) {
            this.fStart = start;
            this.fEnd = end;
            this.fReverse = false;
        } else {
            this.fStart = end;
            this.fEnd = start;
            this.fReverse = true;
        }
        String srcTrace = match.getSource().getTrace().getName();
        String dstTrace = match.getDestination().getTrace().getName();
        String matching = srcTrace.equals(dstTrace) ? srcTrace : String.valueOf(srcTrace) + TRACE_SEPARATOR + dstTrace;
        String type = eventKey == null ? DEFAULT_TYPE : String.valueOf(eventKey.getClass().getSimpleName()) + ':';
        this.fType = String.valueOf(type) + matching;
    }

    public long getStart() {
        return this.fReverse ? this.fEnd : this.fStart;
    }

    public long getEnd() {
        return this.fReverse ? this.fStart : this.fEnd;
    }

    public int getSizeOnDisk() {
        return 17 + SafeByteBufferFactory.getStringSizeInBuffer((String)this.fType);
    }

    public String getName() {
        return this.fType;
    }

    public void writeSegment(@NonNull ISafeByteBufferWriter buffer) {
        buffer.putLong(this.fStart);
        buffer.putLong(this.fEnd);
        buffer.put(this.fReverse ? (byte)1 : -1);
        buffer.putString(this.fType);
    }

    public String toString() {
        return new String(String.valueOf(this.fType) + ':' + '[' + String.valueOf(this.fStart) + TRACE_SEPARATOR + String.valueOf(this.fEnd) + ']');
    }
}

