/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.pcap.core.Activator;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapNgFile;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapOldFile;

public final class PcapHelper {
    private PcapHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable PcapFile getPcapFile(Path filePath) throws IOException, BadPcapFileException {
        if (Files.notExists(filePath, new LinkOption[0])) throw new BadPcapFileException("Bad Pcap File.");
        if (!Files.isRegularFile(filePath, new LinkOption[0])) throw new BadPcapFileException("Bad Pcap File.");
        if (Files.size(filePath) < 24L) {
            throw new BadPcapFileException("Bad Pcap File.");
        }
        if (!Files.isReadable(filePath)) {
            throw new BadPcapFileException("File is not readable.");
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileChannel fileChannel = (FileChannel)NonNullUtils.checkNotNull((Object)Files.newByteChannel(filePath, new OpenOption[0]));){
            ByteBuffer header = ByteBuffer.allocate(8);
            fileChannel.read(header);
            header.flip();
            int blockType = header.getInt();
            try {
                if (blockType == 0xA0D0D0A) {
                    return new PcapNgFile(filePath);
                }
            }
            catch (BadPcapFileException e) {
                Activator activator = Activator.getDefault();
                if (activator == null) return null;
                activator.logWarning(e.getMessage(), e);
                return null;
            }
            if (PcapOldFile.preValidate(filePath)) return new PcapOldFile(filePath);
            return null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

