/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;

public class CheatSheetExpandRestoreAction
extends Action {
    private final CheatSheetViewer viewer;
    private boolean collapsed = false;
    private final ImageDescriptor collapseImage;
    private final ImageDescriptor disabledImage;

    public CheatSheetExpandRestoreAction(String title, boolean initValue, CheatSheetViewer viewer) {
        super(title);
        this.viewer = viewer;
        IPath path = CheatSheetPlugin.ICONS_PATH.append("elcl16/").append("collapse_expand_all.png");
        this.collapseImage = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        path = CheatSheetPlugin.ICONS_PATH.append("dlcl16/").append("collapse_expand_all.png");
        this.disabledImage = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        this.setDisabledImageDescriptor(this.disabledImage);
        this.setImageDescriptor(this.collapseImage);
        this.setCollapsed(initValue);
    }

    public void run() {
        this.viewer.toggleExpandRestore();
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean value) {
        super.setChecked(value);
        this.collapsed = value;
        if (value) {
            this.setToolTipText(Messages.RESTORE_ALL_TOOLTIP);
        } else {
            this.setToolTipText(Messages.COLLAPSE_ALL_BUT_CURRENT_TOOLTIP);
        }
    }
}

