/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.context;

import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;

public final class ServiceHolder<S>
implements Comparable<ServiceHolder<?>> {
    final ServiceObjects<S> serviceObjects;
    final S service;
    final Bundle bundle;
    final long serviceId;
    final int serviceRanking;
    final ClassLoader legacyTCCL;
    private volatile boolean released = false;

    public ServiceHolder(ServiceObjects<S> serviceObjects) {
        this.serviceObjects = serviceObjects;
        this.bundle = serviceObjects.getServiceReference().getBundle();
        this.service = serviceObjects.getService();
        this.legacyTCCL = (ClassLoader)serviceObjects.getServiceReference().getProperty("equinox.legacy.tccl");
        Long serviceIdProp = (Long)serviceObjects.getServiceReference().getProperty("service.id");
        if (this.legacyTCCL != null) {
            serviceIdProp = -serviceIdProp.longValue();
        }
        this.serviceId = serviceIdProp;
        Object rankProp = serviceObjects.getServiceReference().getProperty("service.ranking");
        this.serviceRanking = !Integer.class.isInstance(rankProp) ? 0 : (Integer)rankProp;
    }

    public ServiceHolder(S service, Bundle bundle, long serviceId, int serviceRanking, ClassLoader legacyTCCL) {
        this.service = service;
        this.bundle = bundle;
        this.serviceObjects = null;
        this.serviceId = serviceId;
        this.serviceRanking = serviceRanking;
        this.legacyTCCL = legacyTCCL;
    }

    public S get() {
        return this.service;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public ClassLoader getLegacyTCCL() {
        return this.legacyTCCL;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public void release() {
        if (!this.released && this.serviceObjects != null && this.service != null) {
            try {
                try {
                    this.serviceObjects.ungetService(this.service);
                }
                catch (IllegalStateException illegalStateException) {
                    this.released = true;
                }
            }
            finally {
                this.released = true;
            }
        }
    }

    public ServiceReference<S> getServiceReference() {
        return this.serviceObjects == null ? null : this.serviceObjects.getServiceReference();
    }

    @Override
    public int compareTo(ServiceHolder<?> o) {
        long otherId;
        int thisRanking = this.serviceRanking;
        int otherRanking = o.serviceRanking;
        if (thisRanking != otherRanking) {
            if (thisRanking < otherRanking) {
                return 1;
            }
            return -1;
        }
        long thisId = this.getServiceId();
        if (thisId == (otherId = o.getServiceId())) {
            return 0;
        }
        if (thisId < otherId) {
            return -1;
        }
        return 1;
    }
}

