/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wildwebdeveloper.debug.AbstractDebugAdapterLaunchShortcut;
import org.eclipse.wildwebdeveloper.debug.Messages;
import org.eclipse.wildwebdeveloper.debug.SelectionUtils;
import org.eclipse.wildwebdeveloper.debug.chrome.ChromeRunDebugLaunchShortcut;
import org.eclipse.wildwebdeveloper.util.FileUtils;

public abstract class AbstractRunHTMLDebugTab
extends AbstractLaunchConfigurationTab {
    private Text programPathText;
    private Text argumentsText;
    private Text workingDirectoryText;
    protected Composite resComposite;
    private Text urlText;
    private ControlDecoration urlDecoration;
    private Text webRootText;
    private ControlDecoration webRootDecoration;
    private Button webRootProjectSelectButton;
    private Button webRootFilesystemSelectButton;
    protected AbstractDebugAdapterLaunchShortcut shortcut = new ChromeRunDebugLaunchShortcut();
    private Button filePath;
    private ControlDecoration fileDecoration;
    private Button fileRadio;
    private Button urlRadio;
    private Button programWorkspaceSelectButton;
    private Button programVariablesButton;
    private Button webRootVariablesButton;

    public void createControl(Composite parent) {
        this.resComposite = new Composite(parent, 0);
        this.resComposite.setLayout((Layout)new GridLayout(4, false));
        this.fileRadio = this.createRadioButton(this.resComposite, Messages.FirefoxDebugTab_File);
        this.fileRadio.setToolTipText(Messages.AbstractRunHTMLDebugTab_fileRadioToolTip);
        this.fileRadio.setLayoutData((Object)new GridData(-1, -1, false, false));
        this.fileRadio.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.urlText.setEnabled(false);
            this.webRootText.setEnabled(false);
            this.webRootProjectSelectButton.setEnabled(false);
            this.webRootFilesystemSelectButton.setEnabled(false);
            this.webRootVariablesButton.setEnabled(false);
            this.programPathText.setEnabled(true);
            this.filePath.setEnabled(true);
            this.programWorkspaceSelectButton.setEnabled(true);
            this.programVariablesButton.setEnabled(true);
            this.validateProgramPathAndURL();
            this.updateLaunchConfigurationDialog();
        }));
        Composite programComposite = new Composite(this.resComposite, 0);
        programComposite.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        GridLayout programGL = new GridLayout(1, false);
        programGL.marginHeight = 0;
        programGL.marginWidth = 0;
        programComposite.setLayout((Layout)programGL);
        this.programPathText = new Text(programComposite, 2048);
        this.programPathText.setLayoutData((Object)new GridData(4, -1, true, false));
        this.fileDecoration = new ControlDecoration((Control)this.programPathText, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.fileDecoration.setImage(fieldDecoration.getImage());
        this.programPathText.addModifyListener(event -> {
            this.validateProgramPathAndURL();
            this.updateLaunchConfigurationDialog();
        });
        Composite programButtons = new Composite(programComposite, 0);
        GridLayout programButtonsGL = new GridLayout(3, false);
        programButtonsGL.marginHeight = 0;
        programButtonsGL.marginWidth = 0;
        programButtons.setLayout((Layout)programButtonsGL);
        GridData programButtonsGD = new GridData(0x1000008, 0x1000000, true, false);
        programButtons.setLayoutData((Object)programButtonsGD);
        this.programWorkspaceSelectButton = new Button(programButtons, 8);
        this.programWorkspaceSelectButton.setText(Messages.AbstractRunHTMLDebugTab_browse_workspace);
        this.programWorkspaceSelectButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IResource resource;
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle(Messages.RunProgramTab_program);
            dialog.setMessage(Messages.RunProgramTab_program);
            dialog.setValidator(selection -> {
                if (selection.length == 0) {
                    return new Status(4, "org.eclipse.wildwebdeveloper", 0, "", null);
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object f = objectArray[n2];
                    if (!(f instanceof IFile)) {
                        return new Status(4, "org.eclipse.wildwebdeveloper", 0, "Must select a file", null);
                    }
                    ++n2;
                }
                return new Status(0, "org.eclipse.wildwebdeveloper", 0, "", null);
            });
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setComparator((ViewerComparator)new ResourceComparator(1));
            if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                String arg = resource.getFullPath().toString();
                String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
                this.programPathText.setText(fileLoc);
            }
        }));
        this.filePath = new Button(programButtons, 8);
        this.filePath.setText(Messages.AbstractRunHTMLDebugTab_browse);
        this.filePath.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog filePathDialog = new FileDialog(this.resComposite.getShell());
            filePathDialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
            filePathDialog.setText("Select a .html file to debug");
            String path = filePathDialog.open();
            if (path != null) {
                this.programPathText.setText(path);
            }
        }));
        this.programVariablesButton = new Button(programButtons, 8);
        this.programVariablesButton.setText(Messages.AbstractRunHTMLDebugTab_variables);
        this.programVariablesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String expr;
            StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
            if (dialog.open() == 0 && (expr = dialog.getVariableExpression()) != null) {
                this.programPathText.insert(expr);
            }
        }));
        this.urlRadio = this.createRadioButton(this.resComposite, "URL: ");
        this.urlRadio.setToolTipText(Messages.RunFirefoxDebugTab_URL_Note);
        this.urlRadio.setLayoutData((Object)new GridData(-1, -1, false, false));
        this.urlRadio.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.programPathText.setEnabled(false);
            this.filePath.setEnabled(false);
            this.programWorkspaceSelectButton.setEnabled(false);
            this.programVariablesButton.setEnabled(false);
            this.urlText.setEnabled(true);
            this.webRootText.setEnabled(true);
            this.webRootProjectSelectButton.setEnabled(true);
            this.webRootFilesystemSelectButton.setEnabled(true);
            this.webRootVariablesButton.setEnabled(true);
            this.validateProgramPathAndURL();
            this.updateLaunchConfigurationDialog();
        }));
        this.urlText = new Text(this.resComposite, 2048);
        GridData urlTextGD = new GridData(4, -1, true, false);
        urlTextGD.horizontalSpan = 3;
        this.urlText.setLayoutData((Object)urlTextGD);
        this.urlDecoration = new ControlDecoration((Control)this.urlText, 16512);
        this.urlDecoration.setImage(fieldDecoration.getImage());
        this.urlText.addModifyListener(e -> {
            this.validateProgramPathAndURL();
            this.updateLaunchConfigurationDialog();
        });
        Label webRootLabel = new Label(this.resComposite, 0);
        webRootLabel.setText(Messages.AbstractRunHTMLDebugTab_webRoot_folder);
        GridData webRootLabelGD = new GridData(1, 128, false, false);
        webRootLabel.setLayoutData((Object)webRootLabelGD);
        Composite webRootComposite = new Composite(this.resComposite, 0);
        webRootComposite.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        GridLayout webRootGL = new GridLayout(1, false);
        webRootGL.marginHeight = 0;
        webRootGL.marginWidth = 0;
        webRootComposite.setLayout((Layout)webRootGL);
        this.webRootText = new Text(webRootComposite, 2048);
        this.webRootText.setLayoutData((Object)new GridData(4, -1, true, false));
        this.webRootDecoration = new ControlDecoration((Control)this.webRootText, 16512);
        this.webRootDecoration.setImage(fieldDecoration.getImage());
        this.webRootText.addModifyListener(e -> {
            this.validateProgramPathAndURL();
            this.updateLaunchConfigurationDialog();
        });
        Composite webRootButtons = new Composite(webRootComposite, 0);
        GridLayout webRootButtonsGL = new GridLayout(3, false);
        webRootButtonsGL.marginHeight = 0;
        webRootButtonsGL.marginWidth = 0;
        webRootButtons.setLayout((Layout)webRootButtonsGL);
        GridData webRootButtonsGD = new GridData(0x1000008, 0x1000000, true, false);
        webRootButtons.setLayoutData((Object)webRootButtonsGD);
        this.webRootProjectSelectButton = new Button(webRootButtons, 8);
        this.webRootProjectSelectButton.setText(Messages.AbstractRunHTMLDebugTab_browse_workspace);
        this.webRootProjectSelectButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IResource resource;
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle(Messages.AbstractRunHTMLDebugTab_select_webroot);
            dialog.setMessage(Messages.AbstractRunHTMLDebugTab_select_webroot);
            dialog.setValidator(selection -> {
                if (selection.length == 0) {
                    return new Status(4, "org.eclipse.wildwebdeveloper", 0, "", null);
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object f = objectArray[n2];
                    if (!(f instanceof IProject) && !(f instanceof IFolder)) {
                        return new Status(4, "org.eclipse.wildwebdeveloper", 0, "Must select a project or a folder", null);
                    }
                    ++n2;
                }
                return new Status(0, "org.eclipse.wildwebdeveloper", 0, "", null);
            });
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setComparator((ViewerComparator)new ResourceComparator(1));
            if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                String arg = resource.getFullPath().toString();
                String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
                this.webRootText.setText(fileLoc);
            }
        }));
        this.webRootFilesystemSelectButton = new Button(webRootButtons, 8);
        this.webRootFilesystemSelectButton.setText(Messages.AbstractRunHTMLDebugTab_browse);
        this.webRootFilesystemSelectButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.resComposite.getShell());
            directoryDialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
            directoryDialog.setText(Messages.AbstractRunHTMLDebugTab_select_webroot);
            String path = directoryDialog.open();
            if (path != null) {
                this.webRootText.setText(path);
            }
        }));
        this.webRootVariablesButton = new Button(webRootButtons, 8);
        this.webRootVariablesButton.setText(Messages.AbstractRunHTMLDebugTab_variables);
        this.webRootVariablesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String expr;
            StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
            if (dialog.open() == 0 && (expr = dialog.getVariableExpression()) != null) {
                this.webRootText.insert(expr);
            }
        }));
        new Label(this.resComposite, 0).setText(Messages.RunProgramTab_argument);
        this.argumentsText = new Text(this.resComposite, 2048);
        GridData argsGD = new GridData(4, -1, true, false);
        argsGD.horizontalSpan = 3;
        this.argumentsText.setLayoutData((Object)argsGD);
        this.argumentsText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Label workingDirLabel = new Label(this.resComposite, 0);
        workingDirLabel.setText(Messages.RunProgramTab_workingDirectory);
        GridData workingDirLabelGD = new GridData(1, 128, false, false);
        workingDirLabel.setLayoutData((Object)workingDirLabelGD);
        Composite workingComposite = new Composite(this.resComposite, 0);
        workingComposite.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        GridLayout workingGL = new GridLayout(1, false);
        workingGL.marginHeight = 0;
        workingGL.marginWidth = 0;
        workingComposite.setLayout((Layout)workingGL);
        this.workingDirectoryText = new Text(workingComposite, 2048);
        this.workingDirectoryText.setLayoutData((Object)new GridData(4, -1, true, false));
        this.workingDirectoryText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Composite workingButtons = new Composite(workingComposite, 0);
        GridLayout workingButtonsGL = new GridLayout(3, false);
        workingButtonsGL.marginHeight = 0;
        workingButtonsGL.marginWidth = 0;
        workingButtons.setLayout((Layout)workingButtonsGL);
        GridData workingButtonsGD = new GridData(0x1000008, 0x1000000, true, false);
        workingButtons.setLayoutData((Object)workingButtonsGD);
        Button workingDirectoryWorkspaceButton = new Button(workingButtons, 8);
        workingDirectoryWorkspaceButton.setText(Messages.AbstractRunHTMLDebugTab_browse_workspace);
        workingDirectoryWorkspaceButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IResource resource;
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle(Messages.RunProgramTab_workingDirectory);
            dialog.setMessage(Messages.RunProgramTab_workingDirectory);
            dialog.setValidator(selection -> {
                if (selection.length == 0) {
                    return new Status(4, "org.eclipse.wildwebdeveloper", 0, "", null);
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object f = objectArray[n2];
                    if (!(f instanceof IProject) && !(f instanceof IFolder)) {
                        return new Status(4, "org.eclipse.wildwebdeveloper", 0, "Must select a project or a folder", null);
                    }
                    ++n2;
                }
                return new Status(0, "org.eclipse.wildwebdeveloper", 0, "", null);
            });
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setComparator((ViewerComparator)new ResourceComparator(1));
            if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                String arg = resource.getFullPath().toString();
                String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
                this.workingDirectoryText.setText(fileLoc);
            }
        }));
        Button workingDirectoryButton = new Button(workingButtons, 8);
        workingDirectoryButton.setText(Messages.AbstractRunHTMLDebugTab_browse);
        workingDirectoryButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog workingDirectoryDialog = new DirectoryDialog(this.resComposite.getShell());
            workingDirectoryDialog.setFilterPath(this.workingDirectoryText.getText());
            workingDirectoryDialog.setText("Select folder to watch for changes");
            String path = workingDirectoryDialog.open();
            if (path != null) {
                this.workingDirectoryText.setText(path);
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        Button workingDirectoryVariablesButton = new Button(workingButtons, 8);
        workingDirectoryVariablesButton.setText(Messages.AbstractRunHTMLDebugTab_variables);
        workingDirectoryVariablesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String expr;
            StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
            if (dialog.open() == 0 && (expr = dialog.getVariableExpression()) != null) {
                this.workingDirectoryText.insert(expr);
            }
        }));
        this.setControl((Control)this.resComposite);
    }

    private void validateProgramPathAndURL() {
        this.setDirty(true);
        this.setErrorMessage(null);
        this.fileDecoration.hide();
        this.urlDecoration.hide();
        this.webRootDecoration.hide();
        String errorMessage = null;
        if (this.fileRadio.getSelection()) {
            try {
                File file = new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.programPathText.getText()));
                if (!file.isFile()) {
                    errorMessage = Messages.RunProgramTab_error_unknownFile;
                } else if (!this.shortcut.canLaunch(file)) {
                    errorMessage = "Not a html file";
                } else if (!file.canRead()) {
                    errorMessage = Messages.RunProgramTab_error_nonReadableFile;
                }
            }
            catch (CoreException ex) {
                errorMessage = ex.getMessage();
            }
            if (errorMessage != null) {
                this.setErrorMessage(errorMessage);
                this.fileDecoration.setDescriptionText(errorMessage);
                this.fileDecoration.show();
            }
        } else if (this.urlRadio.getSelection()) {
            try {
                new URL(this.urlText.getText());
            }
            catch (MalformedURLException ex) {
                errorMessage = MessageFormat.format(Messages.RunProgramTab_error_malformedUR, ex.getMessage());
                this.urlDecoration.setDescriptionText(errorMessage);
                this.urlDecoration.show();
            }
            boolean showWebRootDecoration = false;
            if (this.webRootText.getText().isBlank()) {
                errorMessage = Messages.AbstractRunHTMLDebugTab_cannot_debug_without_webroot;
                showWebRootDecoration = true;
            } else {
                try {
                    File file = new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.webRootText.getText()));
                    if (!file.exists()) {
                        errorMessage = Messages.AbstractRunHTMLDebugTab_cannot_access_webroot_folder;
                        showWebRootDecoration = true;
                    } else if (!file.isDirectory()) {
                        errorMessage = Messages.AbstractRunHTMLDebugTab_webroot_folder_is_not_a_directory;
                        showWebRootDecoration = true;
                    }
                }
                catch (CoreException e) {
                    errorMessage = e.getMessage();
                    showWebRootDecoration = true;
                }
                if (showWebRootDecoration) {
                    this.webRootDecoration.setDescriptionText(errorMessage);
                    this.webRootDecoration.show();
                }
                if (errorMessage != null) {
                    this.setErrorMessage(errorMessage);
                }
            }
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String defaultSelectedFile = SelectionUtils.pathOrEmpty(SelectionUtils.getSelectedFile(this.shortcut::canLaunch));
            this.programPathText.setText(configuration.getAttribute("program", defaultSelectedFile));
            this.argumentsText.setText(configuration.getAttribute("runtimeArgs", ""));
            this.workingDirectoryText.setText(configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", SelectionUtils.pathOrEmpty(SelectionUtils.getSelectedProject())));
            this.urlText.setText(configuration.getAttribute("url", ""));
            this.webRootText.setText(configuration.getAttribute("webRoot", ""));
            boolean fileRadioButtonSelected = configuration.getAttribute("fileRadioButtonSelected", true);
            if (fileRadioButtonSelected) {
                this.fileRadio.setSelection(true);
                this.urlRadio.setSelection(false);
                this.programPathText.setEnabled(true);
                this.filePath.setEnabled(true);
                this.programWorkspaceSelectButton.setEnabled(true);
                this.programVariablesButton.setEnabled(true);
                this.urlText.setEnabled(false);
                this.webRootText.setEnabled(false);
                this.webRootProjectSelectButton.setEnabled(false);
                this.webRootFilesystemSelectButton.setEnabled(false);
                this.webRootVariablesButton.setEnabled(false);
            } else {
                this.fileRadio.setSelection(false);
                this.urlRadio.setSelection(true);
                this.programPathText.setEnabled(false);
                this.filePath.setEnabled(false);
                this.programWorkspaceSelectButton.setEnabled(false);
                this.programVariablesButton.setEnabled(false);
                this.urlText.setEnabled(true);
                this.webRootText.setEnabled(true);
                this.webRootProjectSelectButton.setEnabled(true);
                this.webRootFilesystemSelectButton.setEnabled(true);
                this.webRootVariablesButton.setEnabled(true);
            }
            this.validateProgramPathAndURL();
        }
        catch (CoreException e) {
            ILog.get().log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String programPath = this.programPathText.getText();
        configuration.setAttribute("program", programPath);
        configuration.setAttribute("url", this.urlText.getText());
        configuration.setAttribute("webRoot", this.webRootText.getText());
        configuration.setAttribute("fileRadioButtonSelected", this.fileRadio.getSelection());
        configuration.setAttribute("runtimeArgs", this.argumentsText.getText());
        String workingDirectory = this.workingDirectoryText.getText();
        configuration.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", workingDirectory);
        configuration.setMappedResources((IResource[])ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(FileUtils.toUri(programPath)));
    }

    public String getName() {
        return Messages.RunProgramTab_title;
    }
}

