/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editparts.AbstractStructManipulatorEditPart;
import org.eclipse.fordiac.ide.model.commands.change.TransferInstanceCommentsCommand;
import org.eclipse.fordiac.ide.model.helpers.FBEndpointFinder;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.search.dialog.AbstractTypeEntryDataHandler;
import org.eclipse.fordiac.ide.model.search.dialog.FBTypeUpdateDialog;
import org.eclipse.fordiac.ide.model.search.dialog.StructuredDataTypeDataHandler;
import org.eclipse.fordiac.ide.model.search.types.DataTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class TransferInstanceCommentsHandler
extends AbstractHandler {
    private static final int DEFAULT_BUTTON_INDEX = 0;
    private Button outputConnectedOnlyBtn;
    private StructManipulator selectedItem;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection sel = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        final AbstractStructManipulatorEditPart struct = (AbstractStructManipulatorEditPart)((Object)sel.getFirstElement());
        this.selectedItem = struct.getModel();
        String[] labels = new String[]{Messages.TransferInstanceComments_TransferLabel, SWT.getMessage((String)"SWT_Cancel")};
        FBTypeUpdateDialog structUpdateDialog = new FBTypeUpdateDialog(null, Messages.TransferInstanceComments_WizardTitle, "", labels, 0, (AbstractTypeEntryDataHandler)new StructuredDataTypeDataHandler((DataTypeEntry)struct.getModel().getDataType().getTypeEntry()){

            public final List<? extends EObject> performStructSearch() {
                DataTypeInstanceSearch search = new DataTypeInstanceSearch((DataTypeEntry)this.typeEntry);
                List result = search.performSearch();
                result.removeIf(el -> el.equals(struct.getModel()) || TransferInstanceCommentsHandler.isTypedOrContainedInTypedInstance((INamedElement)el));
                if (TransferInstanceCommentsHandler.this.outputConnectedOnlyBtn != null && !TransferInstanceCommentsHandler.this.outputConnectedOnlyBtn.isDisposed() && TransferInstanceCommentsHandler.this.outputConnectedOnlyBtn.getSelection()) {
                    List connectedFbs = FBEndpointFinder.getConnectedFbs(new ArrayList(), (FBNetworkElement)TransferInstanceCommentsHandler.this.selectedItem);
                    result.removeIf(res -> {
                        StructManipulator structMan;
                        return res instanceof StructManipulator && (!(structMan = (StructManipulator)res).getInterface().getEventInputs().isEmpty() || !structMan.getInterface().getInputVars().isEmpty()) && !connectedFbs.contains(res);
                    });
                }
                return result;
            }
        });
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        CommandStack commandStack = (CommandStack)editor.getAdapter(CommandStack.class);
        if (structUpdateDialog.open() == 0) {
            TransferInstanceCommentsCommand cmd = new TransferInstanceCommentsCommand(struct.getModel(), structUpdateDialog.getDataHandler().getCollectedElements().stream().filter(StructManipulator.class::isInstance).map(StructManipulator.class::cast).collect(Collectors.toSet()));
            commandStack.execute((Command)cmd);
        }
        return null;
    }

    public static List<FBNetworkElement> getConnectedFbs(FBNetworkElement src) {
        ArrayList<FBNetworkElement> connectedElements = new ArrayList<FBNetworkElement>();
        ArrayList pins = new ArrayList();
        pins.addAll(src.getInterface().getEventOutputs());
        pins.addAll(src.getInterface().getOutputVars());
        for (IInterfaceElement pin : pins) {
            connectedElements.addAll(TransferInstanceCommentsHandler.getConnectedFbs(pin));
        }
        if (!connectedElements.isEmpty() && (connectedElements.size() == 1 && !((FBNetworkElement)connectedElements.get(0)).equals(src) || connectedElements.size() > 1)) {
            ArrayList<FBNetworkElement> connectedOfConnectedElements = new ArrayList<FBNetworkElement>();
            for (FBNetworkElement element : connectedElements) {
                if (element.equals(src)) continue;
                connectedOfConnectedElements.addAll(TransferInstanceCommentsHandler.getConnectedFbs(element));
            }
            connectedOfConnectedElements.forEach(el -> {
                if (!connectedElements.contains(el)) {
                    connectedElements.add((FBNetworkElement)el);
                }
            });
        }
        return connectedElements.stream().distinct().toList();
    }

    private static List<FBNetworkElement> getConnectedFbs(IInterfaceElement srcPin) {
        ArrayList<FBNetworkElement> connectedElements = new ArrayList<FBNetworkElement>();
        for (Connection con : srcPin.getOutputConnections()) {
            if (con.getDestinationElement() instanceof SubApp) {
                connectedElements.addAll(TransferInstanceCommentsHandler.getConnectedFbs(con.getDestination()));
                continue;
            }
            connectedElements.add(con.getDestinationElement());
        }
        return connectedElements;
    }

    private static boolean isTypedOrContainedInTypedInstance(INamedElement element) {
        SubApp subApp;
        EObject eObject;
        return element.eContainer() != null && (eObject = element.eContainer().eContainer()) instanceof SubApp && ((subApp = (SubApp)eObject).isContainedInTypedInstance() || subApp.isTyped());
    }
}

