/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editors;

import org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeEditor;
import org.eclipse.fordiac.ide.model.ui.editors.GraphicalViewerNavigationLocationData;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.NavigationLocation;

public final class FBTypeNavigationLocation
extends NavigationLocation {
    final IEditorPart activeEditor;
    final INavigationLocation subNavigationLocation;
    final GraphicalViewerNavigationLocationData graphicalViewerLocationData;

    protected FBTypeNavigationLocation(FBTypeEditor editorPart) {
        super((IEditorPart)editorPart);
        this.activeEditor = editorPart.getActiveEditor();
        this.subNavigationLocation = FBTypeNavigationLocation.createSubNavigationLocation(this.activeEditor);
        this.graphicalViewerLocationData = this.subNavigationLocation == null ? FBTypeNavigationLocation.createGraphicalViewerLocationData(this.activeEditor) : null;
    }

    private static INavigationLocation createSubNavigationLocation(IEditorPart activeEditor) {
        if (activeEditor instanceof INavigationLocationProvider) {
            return ((INavigationLocationProvider)activeEditor).createNavigationLocation();
        }
        return null;
    }

    private static GraphicalViewerNavigationLocationData createGraphicalViewerLocationData(IEditorPart activeEditor) {
        GraphicalViewer viewer = (GraphicalViewer)activeEditor.getAdapter(GraphicalViewer.class);
        return viewer != null ? new GraphicalViewerNavigationLocationData(viewer) : null;
    }

    protected FBTypeEditor getEditorPart() {
        IEditorPart part = super.getEditorPart();
        return part instanceof FBTypeEditor ? (FBTypeEditor)part : null;
    }

    public String getText() {
        FBTypeEditor typeEditor = this.getEditorPart();
        if (typeEditor != null) {
            if (this.subNavigationLocation != null) {
                return this.subNavigationLocation.getText();
            }
            return typeEditor.getTitle() + "." + this.activeEditor.getTitle();
        }
        return super.getText();
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    public void restoreLocation() {
        FBTypeEditor part = this.getEditorPart();
        if (part != null) {
            part.setActiveEditor(this.activeEditor);
            if (this.subNavigationLocation != null) {
                this.subNavigationLocation.restoreLocation();
            } else if (this.graphicalViewerLocationData != null) {
                this.restoreGraphicalViewerData(part);
            }
        }
    }

    private void restoreGraphicalViewerData(FBTypeEditor part) {
        GraphicalViewer viewer = part.getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            this.graphicalViewerLocationData.restoreGraphicalViewerData((EditPartViewer)viewer);
        }
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        if (currentLocation instanceof FBTypeNavigationLocation) {
            FBTypeNavigationLocation currentFBTypeLocation = (FBTypeNavigationLocation)currentLocation;
            FBTypeEditor typeEditor = this.getEditorPart();
            if (typeEditor != null && ((Object)((Object)typeEditor)).equals((Object)currentFBTypeLocation.getEditorPart()) && this.activeEditor.equals(currentFBTypeLocation.activeEditor)) {
                if (this.subNavigationLocation != null) {
                    return this.subNavigationLocation.mergeInto(currentFBTypeLocation.subNavigationLocation);
                }
                if (this.graphicalViewerLocationData != null) {
                    return this.graphicalViewerLocationData.equals((Object)currentFBTypeLocation.graphicalViewerLocationData);
                }
                return true;
            }
        }
        return false;
    }

    public void update() {
        if (this.subNavigationLocation != null) {
            this.subNavigationLocation.update();
        }
    }

    public void releaseState() {
        super.releaseState();
        if (this.subNavigationLocation != null) {
            this.subNavigationLocation.releaseState();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.subNavigationLocation != null) {
            this.subNavigationLocation.dispose();
        }
    }
}

