/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.sorters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.VisibilityAssistant;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptorManager;
import org.eclipse.ui.internal.navigator.sorters.CommonSorterDescriptor;
import org.eclipse.ui.internal.navigator.sorters.CommonSorterDescriptorManager;
import org.eclipse.ui.internal.navigator.sorters.SkeletonViewerSorter;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorSorterService;

public class NavigatorSorterService
implements INavigatorSorterService,
VisibilityAssistant.VisibilityListener {
    private final NavigatorContentService contentService;
    private final Map<CommonSorterDescriptor, ViewerSorter> sorters = new HashMap<CommonSorterDescriptor, ViewerSorter>();
    private INavigatorContentDescriptor[] sortOnlyDescriptors;

    public NavigatorSorterService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.computeSortOnlyDescriptors();
    }

    private synchronized void computeSortOnlyDescriptors() {
        ArrayList<NavigatorContentDescriptor> sortOnlyList = new ArrayList<NavigatorContentDescriptor>();
        NavigatorContentDescriptor[] navigatorContentDescriptorArray = NavigatorContentDescriptorManager.getInstance().getSortOnlyContentDescriptors();
        int n = navigatorContentDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            NavigatorContentDescriptor descriptor = navigatorContentDescriptorArray[n2];
            if (this.contentService.isActive(descriptor.getId())) {
                sortOnlyList.add(descriptor);
            }
            ++n2;
        }
        this.sortOnlyDescriptors = sortOnlyList.toArray(new INavigatorContentDescriptor[0]);
    }

    @Override
    public ViewerSorter findSorterForParent(Object aParent) {
        CommonSorterDescriptor[] descriptors = CommonSorterDescriptorManager.getInstance().findApplicableSorters(this.contentService, aParent);
        if (descriptors.length > 0) {
            return this.getSorter(descriptors[0]);
        }
        return SkeletonViewerSorter.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ViewerSorter getSorter(CommonSorterDescriptor descriptor) {
        ViewerSorter sorter = null;
        Map<CommonSorterDescriptor, ViewerSorter> map = this.sorters;
        synchronized (map) {
            sorter = this.sorters.get(descriptor);
            if (sorter == null) {
                sorter = descriptor.createSorter();
                this.sorters.put(descriptor, sorter);
            }
        }
        return sorter;
    }

    @Override
    public synchronized ViewerSorter findSorter(INavigatorContentDescriptor source, Object parent, Object lvalue, Object rvalue) {
        CommonSorterDescriptor[] descriptors;
        CommonSorterDescriptorManager dm = CommonSorterDescriptorManager.getInstance();
        int i = 0;
        while (i < this.sortOnlyDescriptors.length) {
            INavigatorContentDescriptor lookupDesc = this.sortOnlyDescriptors[i];
            if (source != null && source.getSequenceNumber() < lookupDesc.getSequenceNumber()) {
                lookupDesc = source;
                source = null;
                --i;
            }
            if ((descriptors = dm.findApplicableSorters(this.contentService, lookupDesc, parent)).length > 0) {
                return this.getSorter(descriptors[0]);
            }
            ++i;
        }
        if (source != null && (descriptors = dm.findApplicableSorters(this.contentService, source, parent)).length > 0) {
            return this.getSorter(descriptors[0]);
        }
        return null;
    }

    @Override
    public Map findAvailableSorters(INavigatorContentDescriptor theSource) {
        CommonSorterDescriptor[] descriptors = CommonSorterDescriptorManager.getInstance().findApplicableSorters(theSource);
        HashMap<Object, ViewerSorter> sorters = new HashMap<Object, ViewerSorter>();
        int count = 0;
        CommonSorterDescriptor[] commonSorterDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            CommonSorterDescriptor descriptor = commonSorterDescriptorArray[n2];
            if (descriptor.getId() != null && descriptor.getId().length() > 0) {
                sorters.put(descriptor.getId(), this.getSorter(descriptor));
            } else {
                sorters.put(theSource.getId() + ".sorter." + ++count, this.getSorter(descriptor));
            }
            ++n2;
        }
        return sorters;
    }

    @Override
    public void onVisibilityOrActivationChange() {
        this.computeSortOnlyDescriptors();
    }
}

