/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.delete;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.types.DataTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.UpdateFBInstanceChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.UpdateManipulatorChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.delete.DeleteUpdateFBTypeInterfaceChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.delete.DeleteUpdateStructDataTypeMemberVariableChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.delete.RootNodeChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.delete.UpdateUntypedSubappPinChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public class SafeStructDeletionChange
extends CompositeChange {
    final DataTypeEntry deletedStruct;
    final Map<EObject, RootNodeChange> rootChanges = new HashMap<EObject, RootNodeChange>();

    public SafeStructDeletionChange(StructuredType struct) {
        super(MessageFormat.format(Messages.DeleteFBTypeParticipant_Change_SafeDeletionChangeTitle, struct.getName()));
        this.deletedStruct = (DataTypeEntry)struct.getTypeEntry();
        this.createChanges(this.deletedStruct);
    }

    public void createChanges(DataTypeEntry entry) {
        HashSet doneElements = new HashSet();
        if (entry != null) {
            List results = new DataTypeInstanceSearch(entry).performSearch();
            results.forEach(eObject -> {
                StructManipulator muxer;
                VarDeclaration varDecl;
                RootNodeChange rootChange = this.getOrCreateRootChange((EObject)eObject);
                if (eObject instanceof VarDeclaration && doneElements.add(varDecl = (VarDeclaration)eObject)) {
                    if (varDecl.eContainer() instanceof StructuredType) {
                        rootChange.add(new DeleteUpdateStructDataTypeMemberVariableChange(varDecl));
                        this.handleTransitiveRefactoring(varDecl, rootChange, doneElements);
                    } else if (SafeStructDeletionChange.isUntypedSubappPin(varDecl)) {
                        rootChange.add(new UpdateUntypedSubappPinChange(varDecl));
                    } else if (SafeStructDeletionChange.isFbTypePin(varDecl)) {
                        this.handleTransitiveRefactoring(varDecl, rootChange, doneElements);
                    }
                } else if (eObject instanceof StructManipulator && doneElements.add(muxer = (StructManipulator)eObject)) {
                    rootChange.add(new UpdateManipulatorChange(muxer));
                }
            });
        }
    }

    private RootNodeChange getOrCreateRootChange(EObject eObject) {
        if (eObject instanceof INamedElement) {
            eObject = EcoreUtil.getRootContainer((EObject)eObject);
            RootNodeChange change = new RootNodeChange(eObject);
            if (!this.rootChanges.containsKey(eObject)) {
                this.rootChanges.put(eObject, change);
                this.add((Change)change);
            }
        }
        return this.rootChanges.get(eObject);
    }

    private void handleTransitiveRefactoring(VarDeclaration varDecl, RootNodeChange rootChange, Set<EObject> rootElements) {
        DataTypeEntry dataTypeEntry = (DataTypeEntry)varDecl.getType().getTypeEntry();
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)varDecl);
        if (varDecl.getFBNetworkElement() != null) {
            if (rootElements.add((EObject)varDecl.getFBNetworkElement())) {
                rootChange.add(new UpdateFBInstanceChange(varDecl.getFBNetworkElement(), (TypeEntry)dataTypeEntry));
            }
        } else if (rootElements.add(rootContainer)) {
            if (rootContainer instanceof StructuredType) {
                StructuredType stElement = (StructuredType)rootContainer;
                this.createChanges((DataTypeEntry)stElement.getTypeEntry());
            } else if (rootContainer instanceof FBType) {
                FBType fbType = (FBType)rootContainer;
                AnyDerivedType anyDerivedType = dataTypeEntry.getType();
                if (anyDerivedType instanceof StructuredType) {
                    StructuredType type = (StructuredType)anyDerivedType;
                    rootChange.add(new DeleteUpdateFBTypeInterfaceChange(fbType, type));
                }
            }
        }
    }

    private static boolean isUntypedSubappPin(VarDeclaration varDecl) {
        SubApp sub;
        EObject eObject;
        return varDecl.eContainer() != null && (eObject = varDecl.eContainer().eContainer()) instanceof SubApp && !(sub = (SubApp)eObject).isTyped() && !sub.isContainedInTypedInstance();
    }

    private static boolean isFbTypePin(VarDeclaration varDecl) {
        return varDecl.eContainer() != null && varDecl.eContainer().eContainer() instanceof FBType;
    }
}

