/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.internal;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;

public abstract class CreateVariableCommand
extends CreationCommand
implements ScopedCommand {
    private final LibraryElement type;
    private final DataType dataType;
    private final String name;
    private final int index;
    private VarDeclaration varDecl;

    protected CreateVariableCommand(LibraryElement type) {
        this(type, 0, null, null);
    }

    protected CreateVariableCommand(LibraryElement type, int index, String name, DataType dataType) {
        this.type = Objects.requireNonNull(type);
        this.dataType = (DataType)Objects.requireNonNullElse(dataType, IecTypes.ElementaryTypes.BOOL);
        this.name = Objects.requireNonNullElse(name, this.getDefaultVarName());
        this.index = index;
    }

    protected abstract EList<VarDeclaration> getVariableList();

    protected abstract String getDefaultVarName();

    public void execute() {
        this.varDecl = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        this.varDecl.setType(this.dataType);
        this.varDecl.setComment("");
        Value value = LibraryElementFactory.eINSTANCE.createValue();
        value.setValue("");
        this.varDecl.setValue(value);
        this.redo();
        this.varDecl.setName(NameRepository.createUniqueName((INamedElement)this.varDecl, (String)this.name));
    }

    public void undo() {
        this.getVariableList().remove((Object)this.varDecl);
    }

    public VarDeclaration getVarDeclaration() {
        return this.varDecl;
    }

    protected LibraryElement getType() {
        return this.type;
    }

    public void redo() {
        if (this.index >= 0) {
            this.getVariableList().add(this.index, (Object)this.varDecl);
        } else {
            this.getVariableList().add((Object)this.varDecl);
        }
    }

    public Object getCreatedElement() {
        return this.getVarDeclaration();
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.type);
    }
}

