/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.helpers.FBShapeHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Comment;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.util.SpatialHash;
import org.eclipse.fordiac.ide.model.validation.ValidationPreferences;

final class FBNetworkAnnotations {
    private static final int CELL_SIZE = 1000;
    private static final int GRID_SIZE_MIN = 10;
    private static final int GRID_SIZE_MAX = 1000;

    static boolean validateCollisions(FBNetwork network, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Optional<FBNetworkElement> parent = Optional.ofNullable(network.eContainer()).filter(FBNetworkElement.class::isInstance).map(FBNetworkElement.class::cast);
        if (parent.filter(p -> p.getTypeEntry() != null).isPresent()) {
            return true;
        }
        return FBNetworkAnnotations.validateCollisions(parent.filter(FBNetworkAnnotations::isUnfoldedSubapp), network.getNetworkElements(), Predicate.not(FBNetworkElement::isInGroup), diagnostics, context);
    }

    static boolean validateCollisions(Group group, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return FBNetworkAnnotations.validateCollisions(Optional.of(group), group.getGroupElements(), unused -> true, diagnostics, context);
    }

    static boolean validateCollisions(Optional<FBNetworkElement> parent, List<FBNetworkElement> networkElements, Predicate<FBNetworkElement> filter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        double marginLeftRight = (double)FBNetworkAnnotations.getIntPreference(context, "MarginLeftRight") * 100.0;
        double marginTopBottom = (double)FBNetworkAnnotations.getIntPreference(context, "MarginTopBottom") * 100.0;
        int gridSize = Math.clamp((long)networkElements.size(), 10, 1000);
        SpatialHash<FBNetworkElement> spatialHash = new SpatialHash<FBNetworkElement>(1000, gridSize);
        PrecisionDimension parentSize = parent.map(FBNetworkAnnotations::getParentSize).orElse(null);
        for (FBNetworkElement element : networkElements) {
            if (element instanceof ErrorMarkerFBNElement || !filter.test(element)) continue;
            Rectangle elementBounds = FBNetworkAnnotations.getElementBounds(element, marginLeftRight, marginTopBottom);
            if (parent.isPresent() && parentSize != null) {
                boolean parentCollision = FBNetworkAnnotations.checkParentCollision(parent.get(), diagnostics, (Dimension)parentSize, element, elementBounds);
                result &= parentCollision;
            }
            Point bottomRight = elementBounds.getBottomRight();
            Set<FBNetworkElement> collisions = spatialHash.put(elementBounds.x, elementBounds.y, bottomRight.x, bottomRight.y, element);
            if (diagnostics != null) {
                collisions.forEach(other -> diagnostics.add(FBNetworkAnnotations.createCollisionDiagnostic(element, other)));
            }
            result &= collisions.isEmpty();
        }
        return result;
    }

    private static boolean checkParentCollision(FBNetworkElement parent, DiagnosticChain diagnostics, Dimension parentSize, FBNetworkElement element, Rectangle elementBounds) {
        boolean parentCollision;
        int elementRight = elementBounds.x + elementBounds.width;
        boolean bl = parentCollision = elementBounds.x < 0 || elementBounds.y < 0 || elementRight > parentSize.width || elementBounds.y + elementBounds.height > parentSize.height;
        if (diagnostics != null && parentCollision) {
            if (elementRight > parentSize.width) {
                diagnostics.add(FBNetworkAnnotations.createInterfaceBarCollisionDiagnostic(element, parent));
            } else {
                diagnostics.add(FBNetworkAnnotations.createCollisionDiagnostic(element, parent));
            }
        }
        return parentCollision;
    }

    private static PrecisionDimension getParentSize(FBNetworkElement parent) {
        int commentLines = 1;
        if (parent.getComment() != null && !parent.getComment().isBlank()) {
            commentLines = (int)((long)commentLines + parent.getComment().chars().filter(c -> c == 10).count());
        }
        return new PrecisionDimension(parent.getVisibleWidth() - 2.0 * FBShapeHelper.getMaxInterfaceBarWidth(), parent.getVisibleHeight() - (double)(commentLines + 1) * 100.0);
    }

    private static Rectangle getElementBounds(FBNetworkElement element, double marginLeftRight, double marginTopBottom) {
        Position position = element.getPosition();
        PrecisionRectangle bounds = new PrecisionRectangle(position.getX(), position.getY(), element.getVisibleWidth(), element.getVisibleHeight());
        if (!(element instanceof Comment)) {
            bounds.expand(marginLeftRight, marginTopBottom);
        }
        return bounds;
    }

    private static Diagnostic createCollisionDiagnostic(FBNetworkElement element, FBNetworkElement other) {
        return new BasicDiagnostic(ValidationPreferences.getDiagnosticSeverity("collisionSeverity", 2, element), "org.eclipse.fordiac.ide.model.libraryElement", 18, MessageFormat.format(Messages.FBNetworkAnnotations_CollisionMessage, element.getQualifiedName(), other.getQualifiedName()), FordiacMarkerHelper.getDiagnosticData((EObject)element, (EStructuralFeature)LibraryElementPackage.Literals.POSITIONABLE_ELEMENT__POSITION, new String[0]));
    }

    private static Diagnostic createInterfaceBarCollisionDiagnostic(FBNetworkElement element, FBNetworkElement other) {
        return new BasicDiagnostic(ValidationPreferences.getDiagnosticSeverity("rightInterfaceBarCollisionSeverity", 2, element), "org.eclipse.fordiac.ide.model.libraryElement", 18, MessageFormat.format(Messages.FBNetworkAnnotations_InterfaceBarCollisionMessage, element.getQualifiedName(), other.getQualifiedName()), FordiacMarkerHelper.getDiagnosticData((EObject)element, (EStructuralFeature)LibraryElementPackage.Literals.POSITIONABLE_ELEMENT__POSITION, new String[0]));
    }

    private static int getIntPreference(Map<Object, Object> context, String name) {
        return (Integer)context.computeIfAbsent(name, FBNetworkAnnotations::internalGetIntPreference);
    }

    private static Integer internalGetIntPreference(Object key) {
        return Platform.getPreferencesService().getInt("org.eclipse.fordiac.ide.model", (String)key, 0, null);
    }

    private static boolean isUnfoldedSubapp(FBNetworkElement parent) {
        SubApp subApp;
        return parent instanceof SubApp && (subApp = (SubApp)parent).isUnfolded();
    }

    private FBNetworkAnnotations() {
        throw new UnsupportedOperationException();
    }
}

