/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.fb;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluator;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionBody;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;

public class FunctionFBEvaluator
extends FBEvaluator<FunctionFBType> {
    private final Evaluator functionEvaluator;

    public FunctionFBEvaluator(FunctionFBType type, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(type, context, variables, parent);
        this.functionEvaluator = this.createFunctionEvaluator(type.getBody());
    }

    @Override
    public void prepare() {
        this.functionEvaluator.prepare();
    }

    @Override
    public Value evaluate() throws EvaluatorException, InterruptedException {
        if (this.getEventQueue() == null) {
            Value result = this.functionEvaluator.evaluate();
            this.update(this.getVariables().values());
            return result;
        }
        return super.evaluate();
    }

    @Override
    public void evaluate(Event event) throws EvaluatorException, InterruptedException {
        this.functionEvaluator.evaluate();
        this.sendOutputEvents((Iterable<Event>)((FunctionFBType)this.getType()).getInterfaceList().getEventOutputs());
        this.update(this.getVariables().values());
    }

    @Override
    public Set<String> getDependencies() {
        return Stream.of(super.getDependencies(), this.functionEvaluator.getDependencies()).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Map<? extends ICallable, ? extends Evaluator> getChildren() {
        return Collections.emptyMap();
    }

    public Evaluator getFunctionEvaluator() {
        return this.functionEvaluator;
    }

    protected Evaluator createFunctionEvaluator(FunctionBody body) {
        return EvaluatorFactory.createEvaluator(body, body.eClass().getInstanceClass().asSubclass(FunctionBody.class), this.getContext(), this.getVariables().values(), this);
    }
}

