/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBTImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.STFunctionBody;
import org.eclipse.fordiac.ide.model.libraryElement.TextFunctionBody;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class FCTImporter
extends FBTImporter {
    public FCTImporter(IFile file) {
        super(file);
    }

    public FCTImporter(InputStream inputStream, TypeLibrary typeLibrary) {
        super(inputStream, typeLibrary);
    }

    public FCTImporter(CommonElementImporter importer) {
        super(importer);
    }

    @Override
    protected LibraryElement createRootModelElement() {
        return LibraryElementFactory.eINSTANCE.createFunctionFBType();
    }

    @Override
    protected String getStartElementName() {
        return "Function";
    }

    @Override
    protected CommonElementImporter.IChildHandler getBaseChildrenHandler() {
        return name -> {
            switch (name) {
                case "Identification": {
                    this.parseIdentification(this.getElement());
                    break;
                }
                case "VersionInfo": {
                    this.parseVersionInfo(this.getElement());
                    break;
                }
                case "CompilerInfo": {
                    this.getElement().setCompilerInfo(this.parseCompilerInfo());
                    break;
                }
                case "InterfaceList": {
                    this.getElement().setInterfaceList(this.parseInterfaceList("InterfaceList"));
                    break;
                }
                case "FunctionBody": {
                    this.parseFunctionBody(this.getElement());
                    break;
                }
                case "Attribute": {
                    this.parseGenericAttributeNode(this.getElement());
                    this.proceedToEndElementNamed("Attribute");
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        };
    }

    private void parseFunctionBody(FunctionFBType type) throws TypeImportException, XMLStreamException {
        this.processChildren("FunctionBody", name -> {
            if (name.equals("ST") && type.getBody() == null) {
                this.getElement().setBody(this.parseSTFunctionBody());
                return true;
            }
            return false;
        });
    }

    private STFunctionBody parseSTFunctionBody() throws XMLStreamException {
        STFunctionBody body = LibraryElementFactory.eINSTANCE.createSTFunctionBody();
        this.parseFunctionBodyText(body);
        this.proceedToEndElementNamed("ST");
        return body;
    }

    private void parseFunctionBodyText(TextFunctionBody body) throws XMLStreamException {
        String text = this.getAttributeValue("Text");
        if (text != null) {
            body.setText(text);
        } else {
            body.setText(this.readCDataSection());
        }
    }

    @Override
    public FunctionFBType getElement() {
        return (FunctionFBType)super.getElement();
    }
}

