/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.wizards;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Optional;
import java.util.Scanner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.buildpath.Buildpath;
import org.eclipse.fordiac.ide.model.buildpath.util.BuildpathUtil;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.widgets.PackageSelectionProposalProvider;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class NewFBTypeWizardPage
extends WizardNewFileCreationPage {
    private static final Pattern NAME_PATTERN = Pattern.compile("Name=\"\\w+\"");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("Comment=\"[\\w\\s-]+\"");
    private Button openTypeCheckbox;
    private int openTypeParentHeight = -1;
    private boolean openType = true;
    private Text packageNameText;
    private TableViewer templateTableViewer;
    private TemplateInfo[] templateList;
    private FilteredArrayContentProvider templateProvider;

    public NewFBTypeWizardPage(IStructuredSelection selection) {
        super(Messages.NewFBTypeWizardPage_NewTypePage, selection);
        this.setTitle(Messages.NewFBTypeWizardPage_CreateNewType);
        this.setDescription(Messages.NewFBTypeWizardPage_CreateNewTypeFromTemplateType);
        this.setAllowExistingResources(true);
        this.loadTypeTemplates();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected boolean validatePage() {
        if (this.templateList == null || this.templateList.length == 0) {
            this.setErrorMessage(MessageFormat.format(Messages.NewFBTypeWizardPage_NoTypeTemplatesFoundCheckTemplatesDirectory, NewFBTypeWizardPage.getTypeTemplatesFolder().toString()));
            return false;
        }
        if (this.getTypeName().isEmpty()) {
            this.setErrorMessage(Messages.NewFBTypeWizardPage_EmptyTypenameIsNotValid);
            return false;
        }
        Optional errorMessage = IdentifierVerifier.verifyIdentifier((String)this.getTypeName());
        if (errorMessage.isPresent()) {
            this.setErrorMessage((String)errorMessage.get());
            return false;
        }
        Optional packageNameErrorMessage = IdentifierVerifier.verifyPackageName((String)this.getPackageName());
        if (packageNameErrorMessage.isPresent()) {
            this.setErrorMessage((String)packageNameErrorMessage.get());
            return false;
        }
        if (this.getTemplate() == null) {
            this.setErrorMessage(Messages.NewFBTypeWizardPage_NoTypeSelected);
            return false;
        }
        if (this.isDuplicate()) {
            this.setErrorMessage(MessageFormat.format(Messages.NewFBTypeWizardPage_TypeAlreadyExists, this.getFullTypeName()));
            return false;
        }
        if (this.fileExists()) {
            this.setErrorMessage(MessageFormat.format(Messages.NewFBTypeWizardPage_FileAlreadyExists, this.getFileName()));
            return false;
        }
        return super.validatePage();
    }

    private boolean isDuplicate() {
        TypeLibrary typeLibrary = this.getTypeLibrary();
        if (typeLibrary == null) {
            return false;
        }
        String fullTypeName = this.getFullTypeName();
        String fileExtension = IPath.fromFile((File)this.getTemplate()).getFileExtension();
        return switch (fileExtension.toUpperCase()) {
            case "ATP" -> {
                if (typeLibrary.getAttributeTypeEntry(fullTypeName) != null) {
                    yield true;
                }
                yield false;
            }
            case "GCF" -> {
                if (typeLibrary.getGlobalConstantsEntry(fullTypeName) != null) {
                    yield true;
                }
                yield false;
            }
            default -> typeLibrary.find(fullTypeName) != null;
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fileExists() {
        String fileName = this.getFileName().toLowerCase();
        IPath containerPath = this.getContainerFullPath();
        if (containerPath == null) return false;
        if (containerPath.segmentCount() < 2) {
            return false;
        }
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(containerPath);
        if (!folder.exists()) {
            return false;
        }
        try {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource member = iResourceArray[n2];
                if (fileName.equalsIgnoreCase(member.getName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            return false;
        }
    }

    public File getTemplate() {
        if (this.templateTableViewer.getSelection() instanceof StructuredSelection) {
            File file;
            Object selection = this.templateTableViewer.getStructuredSelection().getFirstElement();
            if (selection instanceof TemplateInfo) {
                TemplateInfo info = (TemplateInfo)selection;
                file = info.templateFile;
            } else {
                file = null;
            }
            return file;
        }
        return null;
    }

    public void setTemplateFileFilter(FileFilter filter) {
        this.templateProvider.setFileFilter(filter);
        this.templateTableViewer.refresh();
    }

    public FileFilter getTemplateFileFilter() {
        return this.templateProvider.getFileFilter();
    }

    public TableViewer getTemplateViewer() {
        return this.templateTableViewer;
    }

    protected String getNewFileLabel() {
        return FordiacMessages.TypeName + ":";
    }

    public String getFileName() {
        String[] splited;
        Object retval = super.getFileName();
        if (this.getTemplate() != null && 2 == (splited = this.getTemplate().getName().split("\\.")).length) {
            retval = (String)retval + "." + splited[1];
        }
        return retval;
    }

    public String getTypeName() {
        return super.getFileName();
    }

    public String getFullTypeName() {
        String packageName = this.getPackageName();
        if (!packageName.isBlank()) {
            return packageName + "::" + this.getTypeName();
        }
        return this.getTypeName();
    }

    public boolean getOpenType() {
        return this.openType;
    }

    protected void createAdvancedControls(Composite parent) {
        this.createPackageNameSelection(parent);
        this.createTemplateTypeSelection(parent);
        super.createAdvancedControls(parent);
    }

    private void createPackageNameSelection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label packageNameLabel = new Label(composite, 0);
        packageNameLabel.setText(FordiacMessages.Package + ":");
        packageNameLabel.setFont(parent.getFont());
        this.packageNameText = new Text(composite, 2048);
        this.packageNameText.setText(this.getInitialPackageName());
        this.packageNameText.addListener(24, (Listener)this);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).hint(250, -1).applyTo((Control)this.packageNameText);
        ContentAssistCommandAdapter packageNameProposalAdapter = new ContentAssistCommandAdapter((Control)this.packageNameText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new PackageSelectionProposalProvider(this::getTypeLibrary), null, null, true);
        packageNameProposalAdapter.setProposalAcceptanceStyle(2);
    }

    private void createTemplateTypeSelection(Composite parent) {
        Label fbTypeTypeLabel = new Label(parent, 0);
        fbTypeTypeLabel.setText(FordiacMessages.SelectType + ":");
        fbTypeTypeLabel.setFont(parent.getFont());
        this.templateTableViewer = TableWidgetFactory.createPropertyTableViewer((Composite)parent, (int)4);
        NewFBTypeWizardPage.configureTypeTableLayout(this.templateTableViewer.getTable());
        this.templateProvider = new FilteredArrayContentProvider(this.createTemplatesFileFilter());
        this.templateTableViewer.setContentProvider((IContentProvider)this.templateProvider);
        this.templateTableViewer.setLabelProvider((IBaseLabelProvider)new TypeTemplatesLabelProvider());
        this.templateTableViewer.setInput((Object)this.templateList);
        this.templateTableViewer.addSelectionChangedListener(ev -> this.handleEvent(null));
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.templateTableViewer.getControl().setLayoutData((Object)data);
    }

    private static void configureTypeTableLayout(Table table) {
        TableColumn tc = new TableColumn(table, 16384);
        tc.setText(FordiacMessages.Name);
        tc = new TableColumn(table, 16384);
        tc.setText(FordiacMessages.Description);
        TableLayout tabLayout = new TableLayout();
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 30));
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 70));
        table.setLayout((Layout)tabLayout);
    }

    private void loadTypeTemplates() {
        Object[] files;
        File templateFolder = NewFBTypeWizardPage.getTypeTemplatesFolder();
        FileFilter ff = this.createTemplatesFileFilter();
        if (templateFolder.isDirectory() && (files = templateFolder.listFiles(ff)) != null) {
            Arrays.sort(files);
            this.templateList = new TemplateInfo[files.length];
            int i = 0;
            while (i < files.length) {
                this.templateList[i] = NewFBTypeWizardPage.createTemplateFileInfo((File)files[i]);
                ++i;
            }
        }
    }

    private static File getTypeTemplatesFolder() {
        String templateFolderPath = Platform.getInstallLocation().getURL().getFile();
        return new File(templateFolderPath + File.separatorChar + "template");
    }

    protected FileFilter createTemplatesFileFilter() {
        return pathname -> pathname.getName().toUpperCase().endsWith(".FBT") || pathname.getName().toUpperCase().endsWith(".FCT") || pathname.getName().toUpperCase().endsWith(".ADP") || pathname.getName().toUpperCase().endsWith(".DTP") || pathname.getName().toUpperCase().endsWith(".GCF") || pathname.getName().toUpperCase().endsWith(".SUB") || pathname.getName().toUpperCase().endsWith(".ATP");
    }

    private static TemplateInfo createTemplateFileInfo(File f) {
        String name = f.getName();
        String description = "";
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Scanner nameScanner = new Scanner(f);
                try {
                    try (Scanner commentScanner = new Scanner(f);){
                        name = nameScanner.findWithinHorizon(NAME_PATTERN, 0);
                        name = name.substring(6, name.length() - 1);
                        description = commentScanner.findWithinHorizon(COMMENT_PATTERN, 0);
                        description = description == null ? Messages.NewFBTypeWizardPage_InvalidOrNoComment : description.substring(9, description.length() - 1);
                    }
                    if (nameScanner != null) {
                        nameScanner.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (nameScanner != null) {
                        nameScanner.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            FordiacLogHelper.logError((String)Messages.NewFBTypeWizardPage_CouldNotFindTemplateFiles, (Throwable)e);
        }
        return new TemplateInfo(f, name, description);
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this.openTypeCheckbox != null) {
            this.openTypeCheckbox.dispose();
            this.openTypeCheckbox = null;
            shell.setSize(shellSize.x, shellSize.y - this.openTypeParentHeight);
        } else {
            this.openTypeCheckbox = this.createOpenTypeGroup(composite);
            if (-1 == this.openTypeParentHeight) {
                Point groupSize = this.openTypeCheckbox.computeSize(-1, -1, true);
                this.openTypeParentHeight = groupSize.y;
            }
            shell.setSize(shellSize.x, shellSize.y + this.openTypeParentHeight);
        }
        super.handleAdvancedButtonSelect();
    }

    private Button createOpenTypeGroup(Composite parent) {
        this.openTypeCheckbox = new Button(parent, 32);
        this.openTypeCheckbox.setText(Messages.NewFBTypeWizardPage_OpenTypeForEditingWhenDone);
        this.openTypeCheckbox.setSelection(true);
        this.setPageComplete(this.validatePage());
        this.openTypeCheckbox.addListener(13, ev -> {
            boolean bl = this.openType = this.openTypeCheckbox.getSelection();
        });
        return this.openTypeCheckbox;
    }

    public String getInitialPackageName() {
        IContainer container = this.getSelectedContainer();
        if (container != null) {
            TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibrary(container.getProject());
            IPath relativePath = BuildpathUtil.findRelativePath((Buildpath)typeLibrary.getBuildpath(), (IResource)container).orElse(container.getFullPath());
            return Stream.of(relativePath.segments()).collect(Collectors.joining("::"));
        }
        return "";
    }

    public TypeLibrary getTypeLibrary() {
        IContainer container = this.getSelectedContainer();
        if (container != null) {
            return TypeLibraryManager.INSTANCE.getTypeLibrary(container.getProject());
        }
        return null;
    }

    public IContainer getSelectedContainer() {
        IPath containerFullPath = this.getContainerFullPath();
        if (containerFullPath != null && containerFullPath.segmentCount() > 0) {
            return containerFullPath.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(containerFullPath.segment(0)) : ResourcesPlugin.getWorkspace().getRoot().getFolder(containerFullPath);
        }
        return null;
    }

    public void setPackageName(String packageName) {
        this.packageNameText.setText(packageName);
    }

    public String getPackageName() {
        return this.packageNameText.getText();
    }

    private class FilteredArrayContentProvider
    extends ArrayContentProvider {
        private FileFilter templateFilter;

        public FilteredArrayContentProvider(FileFilter filter) {
            this.templateFilter = filter;
        }

        public void setFileFilter(FileFilter filter) {
            this.templateFilter = filter;
        }

        public FileFilter getFileFilter() {
            return this.templateFilter;
        }

        public Object[] getElements(Object inputElement) {
            Object[] fullList = super.getElements(inputElement);
            if (this.templateFilter == null) {
                return fullList;
            }
            return Arrays.asList(fullList).stream().filter(TemplateInfo.class::isInstance).map(TemplateInfo.class::cast).filter(t -> this.templateFilter.accept(t.templateFile)).toArray();
        }
    }

    private static class TemplateInfo {
        private final File templateFile;
        private final String templateName;
        private final String templateDescription;

        public TemplateInfo(File templateFile, String templateName, String templateDescription) {
            this.templateFile = templateFile;
            this.templateName = templateName;
            this.templateDescription = templateDescription;
        }
    }

    private static class TypeTemplatesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TypeTemplatesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TemplateInfo) {
                TemplateInfo info = (TemplateInfo)element;
                switch (columnIndex) {
                    case 0: {
                        return info.templateName;
                    }
                    case 1: {
                        return info.templateDescription;
                    }
                }
            }
            return "";
        }
    }
}

