/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.hierarchy;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.ReferenceAcceptor;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.ide.editor.hierarchy.AbstractHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.DefaultHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.DefaultHierarchyNodeReference;
import org.eclipse.xtext.ide.editor.hierarchy.ICallHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNodeReference;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.xbase.lib.Procedures;

public class DefaultCallHierarchyBuilder
extends AbstractHierarchyBuilder
implements ICallHierarchyBuilder {
    private ICallHierarchyBuilder.CallHierarchyType hierarchyType = ICallHierarchyBuilder.CallHierarchyType.CALLER;

    @Override
    public Collection<IHierarchyNode> buildRoots(URI rootURI, IProgressMonitor monitor) {
        IEObjectDescription rootDeclaration = this.findDeclaration(rootURI);
        if (rootDeclaration == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new IHierarchyNode[]{this.createRoot(rootDeclaration)});
    }

    @Override
    public Collection<IHierarchyNode> buildChildren(IHierarchyNode parent, IProgressMonitor monitor) {
        if (!parent.mayHaveChildren()) {
            return Collections.emptyList();
        }
        LinkedHashMap children = new LinkedHashMap();
        this.findDeclarations(parent, monitor, (Procedures.Procedure2<? super IEObjectDescription, ? super IReferenceDescription>)((Procedures.Procedure2)(declaration, reference) -> {
            IHierarchyNodeReference nodeReference;
            IHierarchyNode childNode = this.createChild(children, (IEObjectDescription)declaration, parent);
            if (childNode != null && (nodeReference = this.createNodeReference((IReferenceDescription)reference)) != null) {
                childNode.getReferences().add(nodeReference);
            }
        }));
        return children.values();
    }

    protected void findDeclarations(IHierarchyNode parent, IProgressMonitor monitor, Procedures.Procedure2<? super IEObjectDescription, ? super IReferenceDescription> acceptor) {
        if (this.hierarchyType != null) {
            switch (this.hierarchyType) {
                case CALLEE: {
                    this.findTargetDeclarations(parent.getElement().getEObjectURI(), monitor, acceptor);
                    break;
                }
                default: {
                    this.findSourceDeclarations(parent.getElement().getEObjectURI(), monitor, acceptor);
                    break;
                }
            }
        } else {
            this.findSourceDeclarations(parent.getElement().getEObjectURI(), monitor, acceptor);
        }
    }

    protected void findTargetDeclarations(URI sourceDeclarationURI, IProgressMonitor monitor, Procedures.Procedure2<? super IEObjectDescription, ? super IReferenceDescription> acceptor) {
        this.readOnly(sourceDeclarationURI, sourceDeclaration -> {
            ReferenceAcceptor referenceAcceptor = new ReferenceAcceptor(this.getResourceServiceProviderRegistry(), reference -> {
                if (this.filterReference((IReferenceDescription)reference)) {
                    IEObjectDescription targetDeclaration = null;
                    if (reference != null) {
                        targetDeclaration = this.findTargetDeclaration((IReferenceDescription)reference);
                    }
                    acceptor.apply((Object)targetDeclaration, reference);
                }
            });
            this.getReferenceFinder().findAllReferences(sourceDeclaration, (IReferenceFinder.Acceptor)referenceAcceptor, monitor);
            return null;
        });
    }

    protected void findSourceDeclarations(URI targetDeclarationURI, IProgressMonitor monitor, Procedures.Procedure2<? super IEObjectDescription, ? super IReferenceDescription> acceptor) {
        TargetURIs targetURIs = this.collectTargetURIs(targetDeclarationURI);
        ReferenceAcceptor referenceAcceptor = new ReferenceAcceptor(this.getResourceServiceProviderRegistry(), reference -> {
            if (this.filterReference((IReferenceDescription)reference)) {
                IEObjectDescription sourceDeclaration = null;
                if (reference != null) {
                    sourceDeclaration = this.findSourceDeclaration((IReferenceDescription)reference);
                }
                acceptor.apply((Object)sourceDeclaration, reference);
            }
        });
        this.getReferenceFinder().findAllReferences(targetURIs, this.getResourceAccess(), this.getIndexData(), (IReferenceFinder.Acceptor)referenceAcceptor, monitor);
    }

    protected TargetURIs collectTargetURIs(URI targetURI) {
        TargetURIs targetURIs = (TargetURIs)this.getTargetURIProvider().get();
        if (targetURI == null) {
            return targetURIs;
        }
        this.readOnly(targetURI, targetObject -> {
            if (targetObject != null) {
                this.getTargetURICollector().add(targetObject, targetURIs);
            }
            return null;
        });
        return targetURIs;
    }

    protected boolean filterReference(IReferenceDescription reference) {
        return reference != null;
    }

    protected IEObjectDescription findDeclaration(URI objectURI) {
        return this.getDescription(objectURI);
    }

    protected IEObjectDescription findTargetDeclaration(IReferenceDescription reference) {
        return this.findDeclaration(reference.getTargetEObjectUri());
    }

    protected IEObjectDescription findSourceDeclaration(IReferenceDescription reference) {
        return this.findDeclaration(reference.getContainerEObjectURI());
    }

    protected IHierarchyNode createRoot(IEObjectDescription declaration) {
        DefaultHierarchyNode node = new DefaultHierarchyNode();
        node.setElement(declaration);
        node.setMayHaveChildren(true);
        return node;
    }

    protected IHierarchyNode createChild(IEObjectDescription declaration, IHierarchyNode parent) {
        DefaultHierarchyNode node = new DefaultHierarchyNode();
        node.setParent(parent);
        node.setElement(declaration);
        node.setMayHaveChildren(!node.isRecursive());
        return node;
    }

    protected IHierarchyNode createChild(Map<URI, IHierarchyNode> children, IEObjectDescription declaration, IHierarchyNode parent) {
        if (declaration == null) {
            return null;
        }
        IHierarchyNode childNode = children.get(declaration.getEObjectURI());
        if (childNode == null) {
            childNode = this.createChild(declaration, parent);
            children.put(declaration.getEObjectURI(), childNode);
        }
        return childNode;
    }

    protected IHierarchyNodeReference createNodeReference(IReferenceDescription reference) {
        return (IHierarchyNodeReference)this.readOnly(reference.getSourceEObjectUri(), sourceObject -> {
            ITextRegionWithLineInformation textRegion = this.getTextRegion((EObject)sourceObject, reference.getEReference(), reference.getIndexInList());
            String text = this.getText((EObject)sourceObject, textRegion);
            return new DefaultHierarchyNodeReference(text, textRegion, reference);
        });
    }

    protected ITextRegionWithLineInformation getTextRegion(EObject obj, EReference reference, int indexInList) {
        return this.getHierarchyNodeLocationProvider().getTextRegion(obj, (EStructuralFeature)reference, indexInList);
    }

    protected String getText(EObject obj, ITextRegionWithLineInformation textRegion) {
        if (obj == null || textRegion == ITextRegionWithLineInformation.EMPTY_REGION) {
            return "";
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)EcoreUtil.getRootContainer((EObject)obj));
        if (node == null) {
            return "";
        }
        int endOffset = textRegion.getOffset() + textRegion.getLength();
        return node.getRootNode().getText().substring(textRegion.getOffset(), endOffset);
    }

    @Override
    public ICallHierarchyBuilder.CallHierarchyType getHierarchyType() {
        return this.hierarchyType;
    }

    @Override
    public void setHierarchyType(ICallHierarchyBuilder.CallHierarchyType hierarchyType) {
        this.hierarchyType = hierarchyType;
    }
}

