/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.widgets.VariableWidget;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class VariableDialog
extends Dialog {
    private final String title;
    private final List<Variable<?>> variables;
    private final VariableWidget variableWidget;

    protected VariableDialog(Shell shell, String title, List<Variable<?>> variables) {
        super(shell);
        this.title = title;
        this.variables = variables;
        this.variableWidget = new VariableWidget();
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = this.variableWidget.createWidget(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)control);
        this.variableWidget.setInput(this.variables);
        return control;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected int getDialogBoundsStrategy() {
        return 2;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(VariableDialog.class)).getDialogSettings();
        return DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)((Object)((Object)this)).getClass().getSimpleName());
    }

    protected boolean isResizable() {
        return true;
    }

    public List<Variable<?>> getVariables() {
        return this.variables;
    }

    public static Optional<String> open(Shell shell, ITypedElement element, String initialValue) {
        return VariableDialog.open(shell, Messages.VariableDialog_DefaultTitle, element, initialValue);
    }

    public static Optional<String> open(Shell shell, String title, ITypedElement element, String initialValue) {
        Variable<?> variable;
        try {
            variable = VariableDialog.computeInitialValue(element, initialValue);
        }
        catch (InvocationTargetException e) {
            ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)Status.error((String)MessageFormat.format(Messages.VariableDialog_ValueError, element.getQualifiedName()), (Throwable)e.getTargetException()));
            return Optional.empty();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
        VariableDialog dialog = new VariableDialog(shell, title, List.of(variable));
        if (dialog.open() == 0) {
            return Optional.of(variable.toString());
        }
        return Optional.empty();
    }

    public static Optional<String> open(Shell shell, Variable<?> variable) {
        return VariableDialog.open(shell, Messages.VariableDialog_DefaultTitle, variable);
    }

    public static Optional<String> open(Shell shell, String title, Variable<?> variable) {
        return VariableDialog.open(shell, title, Stream.of(variable)).stream().findAny();
    }

    public static List<String> open(Shell shell, Stream<Variable<?>> variables) {
        return VariableDialog.open(shell, Messages.VariableDialog_DefaultTitle, variables);
    }

    public static List<String> open(Shell shell, String title, Stream<Variable<?>> variables) {
        List<Variable<?>> copies = variables.map(VariableOperations::newVariable).toList();
        VariableDialog dialog = new VariableDialog(shell, title, copies);
        if (dialog.open() == 0) {
            return copies.stream().map(Object::toString).toList();
        }
        return List.of();
    }

    public static Variable<?> computeInitialValue(ITypedElement element, String initialValue) throws InvocationTargetException, InterruptedException {
        Variable[] result = new Variable[1];
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(moniotr -> {
            Variable variable = VariableOperations.newVariable((ITypedElement)element, (String)initialValue);
        });
        return result[0];
    }
}

