/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Leaf;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.RootLevel;
import org.eclipse.fordiac.ide.hierarchymanager.ui.refactoring.SafeResourceRefactoringChange;
import org.eclipse.fordiac.ide.hierarchymanager.ui.util.HierarchyManagerRefactoringUtil;
import org.eclipse.fordiac.ide.hierarchymanager.ui.util.HierarchyManagerUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class RenameFileParticipant
extends RenameParticipant {
    private List<IFile> files = new ArrayList<IFile>();
    private IResource element;
    private RootLevel plantHierarchy;

    protected boolean initialize(Object element) {
        if (element instanceof IResource) {
            IResource resource;
            this.element = resource = (IResource)element;
            if (!HierarchyManagerRefactoringUtil.plantHierachyExists(resource.getProject())) {
                this.plantHierarchy = null;
            } else {
                this.plantHierarchy = HierarchyManagerRefactoringUtil.getPlantHierarchy(resource.getProject());
                try {
                    this.files = HierarchyManagerRefactoringUtil.getFilesFromResource(resource);
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }
        return this.plantHierarchy != null && !this.files.isEmpty();
    }

    public String getName() {
        return "Fix references on plant hierarchy";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask("Creating change...", 1);
            ArrayList<Leaf> leaves = new ArrayList<Leaf>();
            for (IFile file : this.files) {
                List<Leaf> matches = HierarchyManagerUtil.searchLeaf(this.plantHierarchy, leaf -> leaf.getContainerFileName().contains(file.getName()));
                leaves.addAll(matches);
            }
            if (!leaves.isEmpty()) {
                SafeResourceRefactoringChange safeResourceRefactoringChange = new SafeResourceRefactoringChange(this.plantHierarchy, leaves, HierarchyManagerRefactoringUtil.getOldPath(this.element), HierarchyManagerRefactoringUtil.getNewPath(this.element, this.getArguments().getNewName()));
                return safeResourceRefactoringChange;
            }
        }
        finally {
            pm.done();
        }
        return null;
    }
}

