/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.util.Objects;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.EnumeratedType;
import org.eclipse.fordiac.ide.model.data.EnumeratedValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyDerivedValue;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;

public final class EnumValue
implements AnyDerivedValue {
    private final EnumeratedValue value;

    public EnumValue(EnumeratedValue value) {
        this.value = Objects.requireNonNull(value);
    }

    public EnumValue(EnumeratedType type) {
        this.value = (EnumeratedValue)type.getEnumeratedValues().getFirst();
    }

    public EnumeratedType getType() {
        return this.value.getType();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumValue other = (EnumValue)obj;
        return this.value == other.value || this.getType().isAssignableFrom((DataType)other.getType()) && this.value.getName().equals(other.value.getName());
    }

    public String toString() {
        return PackageNameHelper.getFullTypeName((LibraryElement)this.getType()) + "#" + this.value.getName();
    }

    public EnumeratedValue getValue() {
        return this.value;
    }
}

