/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.variable;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.Subrange;
import org.eclipse.fordiac.ide.model.eval.value.ArrayValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.AbstractVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.value.TypedValue;

public class ArrayVariable
extends AbstractVariable<ArrayValue>
implements Iterable<Variable<?>> {
    private final ArrayValue value;

    public ArrayVariable(String name, ArrayType type) {
        super(name, (LibraryElement)type);
        this.value = new ArrayValue(type);
    }

    public ArrayVariable(String name, ArrayType type, String value) {
        super(name, (LibraryElement)type);
        this.value = new ArrayValue((ArrayValue)ValueOperations.parseValue(value, (LibraryElement)type, null));
    }

    public ArrayVariable(String name, ArrayType type, Value value) {
        super(name, (LibraryElement)ArrayVariable.withKnownBounds(type, value));
        this.value = new ArrayValue(this.checkValue(value));
    }

    @Override
    public void setValue(Value value) {
        ArrayValue arrayValue = this.checkValue(value);
        IntStream.rangeClosed(Math.max(this.value.getStart(), arrayValue.getStart()), Math.min(this.value.getEnd(), arrayValue.getEnd())).forEach((int index) -> this.value.get(index).setValue((Value)arrayValue.get(index).getValue()));
    }

    protected ArrayValue checkValue(Value value) {
        ArrayValue arrayValue;
        block3: {
            block2: {
                if (!(value instanceof ArrayValue)) break block2;
                arrayValue = (ArrayValue)value;
                if (this.getType().isAssignableFrom((DataType)arrayValue.getType())) break block3;
            }
            throw this.createCastException(value);
        }
        return arrayValue;
    }

    @Override
    public void setValue(TypedValue value) {
        if (!this.getType().isAssignableFrom(value.type())) {
            this.createCastException(value);
        }
        List elements = (List)value.value();
        int commonSize = Math.min(this.value.getElements().size(), elements.size());
        IntStream.range(0, commonSize).forEach((int index) -> this.value.getRaw(index).setValue(new TypedValue(this.getElementType(), elements.get(index))));
        IntStream.range(commonSize, this.value.getElements().size()).forEach((int index) -> this.value.getRaw(index).setValue(ValueOperations.defaultValue((LibraryElement)this.getElementType())));
    }

    public ArrayType getType() {
        return (ArrayType)super.getType();
    }

    protected static ArrayType withKnownBounds(ArrayType type, Value value) {
        if (value instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)value;
            return ArrayVariable.withKnownBounds(type, (List<Subrange>)arrayValue.getType().getSubranges());
        }
        if (value != null) {
            throw new ClassCastException("Cannot assign value with incompatible type " + value.getType().getName() + " as " + type.getName());
        }
        return type;
    }

    protected static ArrayType withKnownBounds(ArrayType type, List<Subrange> knownSubranges) {
        if (type.getSubranges().size() != knownSubranges.size()) {
            throw new ClassCastException("Cannot assign value with incompatible subranges " + String.valueOf(knownSubranges) + " as " + type.getName());
        }
        if (type.getSubranges().stream().anyMatch(subrange -> !subrange.isSetLowerLimit() || !subrange.isSetUpperLimit())) {
            return ArrayVariable.newArrayType(type.getBaseType(), IntStream.range(0, type.getSubranges().size()).mapToObj(index -> ArrayVariable.mergeSubrange((Subrange)type.getSubranges().get(index), (Subrange)knownSubranges.get(index))).map(EcoreUtil::copy).toList());
        }
        return type;
    }

    private static Subrange mergeSubrange(Subrange typeSubrange, Subrange valueSubrange) {
        return typeSubrange.isSetLowerLimit() && typeSubrange.isSetUpperLimit() ? typeSubrange : valueSubrange;
    }

    public static ArrayType newArrayType(DataType arrayBaseType, Subrange ... arraySubranges) {
        return ArrayVariable.newArrayType(arrayBaseType, List.of(arraySubranges));
    }

    public static ArrayType newArrayType(DataType arrayBaseType, List<Subrange> arraySubranges) {
        ArrayType arrayType = DataFactory.eINSTANCE.createArrayType();
        arrayType.setName("ARRAY " + arraySubranges.stream().map(subrange -> subrange.isSetLowerLimit() && subrange.isSetUpperLimit() ? subrange.getLowerLimit() + ".." + subrange.getUpperLimit() : "*").collect(Collectors.joining(", ", "[", "]")) + " OF " + arrayBaseType.getName());
        arrayType.setBaseType(arrayBaseType);
        arrayType.getSubranges().addAll(arraySubranges);
        return arrayType;
    }

    public static Subrange newSubrange(int lower, int upper) {
        Subrange subrange = DataFactory.eINSTANCE.createSubrange();
        subrange.setLowerLimit(lower);
        subrange.setUpperLimit(upper);
        return subrange;
    }

    @Override
    public Iterator<Variable<?>> iterator() {
        return this.value.getElements().iterator();
    }

    public DataType getElementType() {
        return this.value.getElementType();
    }

    public List<Variable<?>> getElements() {
        return this.value.getElements();
    }

    @Override
    public Stream<Variable<?>> getChildren() {
        return this.getElements().stream();
    }

    @Override
    public ArrayValue getValue() {
        return this.value;
    }
}

