/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.fordiac.ide.typemanagement.navigator.FBTypeComposedAdapterFactory;
import org.eclipse.fordiac.ide.typemanagement.navigator.LibraryElementContentProvider;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;

public class FBTypeContentProvider
extends LibraryElementContentProvider
implements IResourceChangeListener {
    public FBTypeContentProvider() {
        super((AdapterFactory)FBTypeComposedAdapterFactory.getAdapterFactory());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 17);
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return file.getParent();
        }
        return super.getParent(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IFile) {
            return true;
        }
        return super.hasChildren(element);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            ArrayList<IResource> list = new ArrayList<IResource>();
            event.getDelta().accept(delta -> {
                IMarkerDelta[] iMarkerDeltaArray = delta.getMarkerDeltas();
                int n = iMarkerDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                    IResource resource = markerDelta.getResource();
                    while (resource != null) {
                        list.add(resource);
                        resource = resource.getParent();
                    }
                    ++n2;
                }
                return true;
            });
            if (!list.isEmpty()) {
                this.performViewerRefresh(list);
            }
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)"Couldn't refresh markers", (Throwable)e);
        }
    }

    private void performViewerRefresh(List<IResource> list) {
        Display.getDefault().asyncExec(() -> {
            Viewer viewer = this.viewer;
            if (viewer instanceof CommonViewer) {
                CommonViewer cViewer = (CommonViewer)viewer;
                if (!this.viewer.getControl().isDisposed()) {
                    cViewer.update(list.toArray(), null);
                }
            }
        });
    }
}

