/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.globalconstantseditor.util;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.STGlobalConstants;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.STGlobalConstsSource;
import org.eclipse.fordiac.ide.globalconstantseditor.services.GlobalConstantsGrammarAccess;
import org.eclipse.fordiac.ide.globalconstantseditor.util.GlobalConstantsPartition;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.util.STAbstractCorePartitioner;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCorePartition;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;

public class GlobalConstantsPartitioner
extends STAbstractCorePartitioner<VarDeclaration> {
    @Inject
    private GlobalConstantsGrammarAccess grammarAccess;

    public String combine(LibraryElement libraryElement) {
        if (libraryElement instanceof GlobalConstants) {
            GlobalConstants globalConstants = (GlobalConstants)libraryElement;
            return GlobalConstantsPartitioner.combine(globalConstants);
        }
        return "";
    }

    public static String combine(GlobalConstants globalConstants) {
        String text;
        if (globalConstants.getSource() != null && (text = globalConstants.getSource().getText()) != null && text.contains("GLOBALCONSTANTS")) {
            return text;
        }
        return GlobalConstantsPartitioner.generateGlobalConstantsText(globalConstants);
    }

    protected static String generateGlobalConstantsText(GlobalConstants globalConstants) {
        StringBuilder builder = new StringBuilder();
        GlobalConstantsPartitioner.generatePackage((LibraryElement)globalConstants, (StringBuilder)builder);
        GlobalConstantsPartitioner.generateImports((LibraryElement)globalConstants, (StringBuilder)builder);
        builder.append("GLOBALCONSTANTS ").append(globalConstants.getName());
        builder.append("\n");
        builder.append("    VAR_GLOBAL CONSTANT");
        builder.append("\n");
        globalConstants.getConstants().stream().forEach(constant -> {
            builder.append("        ");
            GlobalConstantsPartitioner.generateVariable((VarDeclaration)constant, (StringBuilder)builder);
            builder.append("\n");
        });
        builder.append("    END_VAR");
        builder.append("\n");
        builder.append("END_GLOBALCONSTANTS");
        builder.append("\n");
        return builder.toString();
    }

    public Optional<STCorePartition> partition(XtextResource resource) {
        if (resource.getEntryPoint() != null && resource.getEntryPoint() != this.grammarAccess.getSTGlobalConstsSourceRule()) {
            return Optional.empty();
        }
        EObject source = (EObject)resource.getContents().get(0);
        if (source instanceof STGlobalConstsSource) {
            STGlobalConstsSource globalConstsSource = (STGlobalConstsSource)source;
            return this.partition(globalConstsSource);
        }
        return Optional.empty();
    }

    protected Optional<STCorePartition> partition(STGlobalConstsSource source) {
        try {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)source);
            String text = node != null ? node.getText() : null;
            List<Import> imports = source.getImports().stream().map(STAbstractCorePartitioner::convertImport).filter(Objects::nonNull).toList();
            ArrayList constants = Optional.ofNullable(source.getConstants()).stream().map(STGlobalConstants::getElements).flatMap(Collection::stream).map(STVarDeclarationBlock::getVarDeclarations).flatMap(Collection::stream).map(arg_0 -> ((GlobalConstantsPartitioner)this).convertVariable(arg_0)).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
            GlobalConstantsPartitioner.handleDuplicates((List)constants);
            return Optional.of(new GlobalConstantsPartition(source.getName(), imports, text, constants));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

