/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.fordiac.ide.model.edit.providers.TypeImageProvider;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.navigator.FBTypeComposedAdapterFactory;
import org.eclipse.fordiac.ide.typemanagement.navigator.LibraryElementLabelProvider;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class FBTypeLabelProvider
extends LibraryElementLabelProvider
implements IDescriptionProvider {
    public FBTypeLabelProvider() {
        super((AdapterFactory)FBTypeComposedAdapterFactory.getAdapterFactory());
    }

    public Image getImage(Object element) {
        IFile file;
        if (element instanceof IFile && (file = (IFile)element).exists()) {
            return this.getDecoratedImage((IResource)file, FBTypeLabelProvider.getImageForFile(file));
        }
        return super.getImage(element);
    }

    public static ImageDescriptor getImageForFile(IFile file) {
        FordiacImage fordiacImage;
        TypeEntry typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
        if (typeEntry != null && (fordiacImage = TypeImageProvider.get4diacImageForTypeEntry((TypeEntry)typeEntry)) != null) {
            return fordiacImage.getImageDescriptor();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return FBTypeLabelProvider.getTextForFBFile(file);
        }
        return super.getText(element);
    }

    private static String getTextForFBFile(IFile element) {
        if ("ADP".equalsIgnoreCase(element.getFileExtension()) || "FBT".equalsIgnoreCase(element.getFileExtension()) || "FCT".equalsIgnoreCase(element.getFileExtension()) || "SUB".equalsIgnoreCase(element.getFileExtension())) {
            return TypeEntry.getTypeNameFromFile((IFile)element);
        }
        return null;
    }

    public String getDescription(Object anElement) {
        if (anElement instanceof IFile) {
            IFile file = (IFile)anElement;
            return FBTypeLabelProvider.getDescriptionForFBFile(file);
        }
        return null;
    }

    private static String getDescriptionForFBFile(IFile element) {
        TypeEntry typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(element);
        if (typeEntry != null) {
            return FBTypeLabelProvider.generateTypeDescriptionString(typeEntry);
        }
        return null;
    }

    private static String generateTypeDescriptionString(TypeEntry typeEntry) {
        String typeName = typeEntry.getTypeName();
        String comment = typeEntry.getComment();
        if (comment != null) {
            return typeName + ": " + comment;
        }
        return typeName;
    }
}

