/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.connection;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.AbstractCommandChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.connection.commands.ReplaceVarsWithStructCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ReplaceVarsWithStructChange
extends AbstractCommandChange<FBType> {
    private final Collection<String> vars;
    final URI structURI;
    private final String name;
    private final boolean isInput;
    private final int position;

    protected ReplaceVarsWithStructChange(URI elementURI, Collection<String> vars, URI structURI, String name, boolean isInput, int position) {
        super(elementURI.trimFileExtension().lastSegment() + Messages.ReplaceVarsWithStructChange_Replace + (isInput ? Messages.ReplaceVarsWithStructChange_Inputs : Messages.ReplaceVarsWithStructChange_Outputs) + String.valueOf(vars) + Messages.ReplaceVarsWithStructChange_Struct + structURI.trimFileExtension().lastSegment(), elementURI, FBType.class);
        this.vars = Objects.requireNonNull(vars);
        this.structURI = Objects.requireNonNull(structURI);
        this.name = Objects.requireNonNull(name);
        this.isInput = isInput;
        this.position = position;
    }

    @Override
    public void initializeValidationData(FBType element, IProgressMonitor pm) {
    }

    @Override
    public RefactoringStatus isValid(FBType element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        this.vars.forEach(varName -> {
            if (this.isInput && element.getInterfaceList().getInput(varName) == null || !this.isInput && element.getInterfaceList().getOutput(varName) == null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)(varName + Messages.ReplaceVarsWithStructChange_NotContained + String.valueOf(this.getElementURI()))));
            }
        });
        return status;
    }

    @Override
    protected Command createCommand(FBType element) {
        LibraryElement libraryElement = TypeLibraryManager.INSTANCE.getTypeEntryForURI(this.structURI).getType();
        if (libraryElement instanceof StructuredType) {
            StructuredType struct = (StructuredType)libraryElement;
            return new ReplaceVarsWithStructCommand(this.vars, (DataType)struct, this.name, element.getInterfaceList(), this.isInput, this.position);
        }
        return null;
    }
}

